<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require 's3ImageUploadFunction.php';
$response = array();

// Custom error handler function
function customErrorHandler($severity, $message, $file, $line) {
    http_response_code(500);
    $errorResponse = array(
        'code' => 500,
        'error' => 'An error occurred: ' . $message,
        'file' => $file,
        'line' => $line
    );
    echo json_encode($errorResponse);
    exit;
}

// Register the custom error handler for standard errors
set_error_handler('customErrorHandler');

// Register a shutdown function to handle fatal errors
register_shutdown_function(function () {
    $error = error_get_last();
    if ($error !== null && $error['type'] & (E_ERROR | E_PARSE | E_CORE_ERROR | E_CORE_WARNING | E_COMPILE_ERROR | E_COMPILE_WARNING)) {
        customErrorHandler($error['type'], $error['message'], $error['file'], $error['line']);
    }
});

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["companyName"]) && !empty($data["folderName"]) && !empty($data["imageName"])) {
    try {
        $companyName = $data['companyName'];
        $folderName = $data['folderName'];
        $imageName = $data['imageName'];

        // Attempt to call the function
        $presignedUrlFunctionCall = getPreAssignUrl($companyName, $folderName, $imageName);

        $response['code'] = 200;
        $response['presignedUrl'] = $presignedUrlFunctionCall;

    } catch (AwsException $e) {
        // Handle specific AWS exception
        error_log($e->getMessage());
        $response['code'] = 500;
        $response['error'] = 'AWS Exception: ' . $e->getMessage();
    } catch (Exception $e) {
        // Handle generic exception
        error_log($e->getMessage());
        $response['code'] = 500;
        $response['error'] = 'An error occurred: ' . $e->getMessage();
    }
} else {
    $response['code'] = 500;
    $response['error'] = 'Fields Are Missing ';
}

echo json_encode($response);


?>