<?php
// include("../db_config/config.php");

function getIcCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $from = $fromDate;
    $to = $toDate;
    $count = 0;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmer` WHERE `empId` IN ($rowHq) AND `farmerRegDate` BETWEEN '$from' AND '$to'";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getSdCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmactivity` LEFT JOIN `tbl_farmer` ON `tbl_farmactivity`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `SD_date` BETWEEN '$from' AND '$to' AND `tbl_farmer`.`empId` IN ($rowHq)";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getSdvCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmactivity` LEFT JOIN `tbl_farmer` ON `tbl_farmactivity`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `SDV_date` BETWEEN '$from' AND '$to' AND `tbl_farmer`.`empId` IN ($rowHq)";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getFdCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmactivityFD` LEFT JOIN `tbl_farmer` ON `tbl_farmactivityFD`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `FD_date` BETWEEN '$from' AND '$to' AND `tbl_farmer`.`empId` IN ($rowHq)";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}


function getFmCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_farmermeeting` WHERE `empId` IN ($rowHq) AND `fmDate` BETWEEN '$from' AND '$to'";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getAvCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $count = 0;
    $from = $fromDate;
    $to = $toDate;
    $sql = "SELECT count(*) AS totalCount FROM `tbl_agencyvisit` WHERE `empId` IN ($rowHq) AND `visitDate` BETWEEN '$from' AND '$to'";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getRevisitCountEmp($rowHq,$fromDate,$toDate){
    global $d;
    global $con;
    $count = 0;
    $from = $from.' 00:00:00';
    $to = $to.' 23:59:59'; 
    $sql = "SELECT count(*) AS totalCount FROM `tbl_revisit` WHERE `empId` IN ($rowHq) AND `revisit_datetime` BETWEEN '$from' AND '$to'";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}

function getDealerCountEmp($empId,$fromDate,$toDate){
    global $con;
    $sql = "SELECT COUNT(*) AS totalCount FROM `tbl_agency` LEFT JOIN `tbl_agencydetail` ON `tbl_agency`.`agencyId` = `tbl_agencydetail`.`agencyId` WHERE `tbl_agency`.`empid` = '$empId' AND `tbl_agency`.`agencyType` = 1 AND `tbl_agencydetail`.`date` BETWEEN '$fromDate' AND '$toDate'";
    $query = mysqli_query($con,$sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        $rs = mysqli_fetch_array($query);
        $count = $rs["totalCount"];
    }
    return $count;
}


function getEmployeeDetail($empId){
    global $con;
    $employeeDetail = array();
    $sql = "SELECT * FROM `tbl_employee` LEFT JOIN `tbl_category` ON `tbl_employee`.`region` = `tbl_category`.`category_id` LEFT JOIN `tbl_designation` ON `tbl_designation`.`designationId` = `tbl_employee`.`empDesignation`  WHERE `tbl_employee`.`id` IN ($empId)";//echo "<br>";
    $result =$con->query($sql);
    while($data = $result->fetch_assoc()){
        $employeeDetail['empName'] = $data['emp_name'];
        $employeeDetail['empDesignation'] = $data['designationName'];
        $employeeDetail['empRegionName'] = $data['category_name'];
    }
    return $employeeDetail;
}

function getAgencyDetail($empId){
    global $con;
    $employeeAgencyDetail = array();
    $employeeAgencyDetail1 = array();
    $sql = "SELECT * FROM `tbl_agency` t1 LEFT JOIN  `tbl_agencydetail` t5 ON t1.`agencyId` = t5.agencyId LEFT JOIN  `tbl_employee` t2 ON t5.`empId` = t2.`id` LEFT JOIN `tbl_designation` t3 ON t2.empDesignation = t3.`designationId` LEFT JOIN `tbl_category` t4 ON t2.region = t4.`category_id` WHERE t1.agencyType='1' AND t5.empId IN ($empId)";//echo "<br>";
    $result =$con->query($sql);
    while($data = $result->fetch_assoc()){
        if($data['deleteflag'] == 0){
            $accountType = 'Active';
        }else{
            $accountType = 'Deactive';
        }
        
        $employeeAgencyDetail['empName'] = $data['emp_name'];
        $employeeAgencyDetail['empDesignation'] = $data['designationName'];
        $employeeAgencyDetail['empRegionName'] = $data['category_name'];
        $employeeAgencyDetail['accountType'] = $accountType;
        $employeeAgencyDetail['agencyName'] = $data['agencyName'];
        $employeeAgencyDetail['agencyShopName'] = $data['agencyShopName'];
        $employeeAgencyDetail['agencyMobile'] = $data['agencyMobile'];
        $employeeAgencyDetail['agencyAddress'] = $data['agencyAddress'];
        $employeeAgencyDetail['agencyTurnover'] = $data['agencyTurnover'];
        $employeeAgencyDetail['sealerPgrPer'] = $data['sealerPgrPer'];
        $employeeAgencyDetail['sellerPN'] = $data['sellerPN'];
        $employeeAgencyDetail['agencyHerbicidePer'] = $data['agencyHerbicidePer'];
        $employeeAgencyDetail['agencyInsecticidePer'] = $data['agencyInsecticidePer'];
        $employeeAgencyDetail['delaerFungicidePer'] = $data['delaerFungicidePer'];
        $employeeAgencyDetail['agencyGAPLTurnover'] = $data['agencyGAPLTurnover'];
        $employeeAgencyDetail['sealerGAPLPgrPer'] = $data['sealerGAPLPgrPer'];
        $employeeAgencyDetail['GAPLPN'] = $data['GAPLPN'];
        $employeeAgencyDetail['agencyGAPLHerbicidePer'] = $data['agencyGAPLHerbicidePer'];
        $employeeAgencyDetail['agencyGAPLInsecticidePer'] = $data['agencyGAPLInsecticidePer']; 
        $employeeAgencyDetail['delaerGAPLFungicidePer'] = $data['delaerGAPLFungicidePer'];
        $employeeAgencyDetail['agencyFirstCompanyName'] = $data['agencyFirstCompanyName'];
        $employeeAgencyDetail['agencyFirstCompanyTr'] = $data['agencyFirstCompanyTr'];
        $employeeAgencyDetail['agencySecCompanyName'] = $data['agencySecCompanyName'];
        $employeeAgencyDetail['agencySecCompanyTr'] = $data['agencySecCompanyTr'];
        $employeeAgencyDetail['agencyThCompanyName'] = $data['agencyThCompanyName'];
        $employeeAgencyDetail['agencyThCompanyTr'] = $data['agencyThCompanyTr'];
        $employeeAgencyDetail['agencyFarmerNetwork'] = $data['agencyFarmerNetwork'];
        $employeeAgencyDetail1[] = $employeeAgencyDetail;
        
    }
    return $employeeAgencyDetail1;
}


function getRegionwiseEmployee($region){
    global $con;
    $employeeIds = array();
    $region;
    $sql = "SELECT * FROM `tbl_employee` WHERE `tbl_employee`.`region` IN ($region)";//echo "<br>";
    $query = $con->query($sql);
    $count = mysqli_num_rows($query);
    if($count > 0){
        while($data = $query->fetch_assoc()){
             $employeeIds['empId'] = $data['id'];
        }
    }
    return $employeeIds;
}


function showEmpPageHeader($regionName,$reportDate){
    $header .= '<h2 style="text-align:center">GAVL CONNECT</h2>';
    $header .= '<h3 style="text-align:center">Daily Activity Report</h3>';
    $header .= '<h3 style="text-align:center">'.$regionName.'<br>'. $reportDate .'</h3>';
    return $header;
}

function showEmpDealerProfilingPageHeader($regionName,$reportDate){
    $header .= '<h2 style="text-align:center">GAVL CONNECT</h2>';
    $header .= '<h3 style="text-align:center">UNITWISE DEALER PROFILE</h3>';
    $header .= '<h3 style="text-align:center">'.$regionName.'<br>As on : '. $reportDate .'</h3>';
    return $header;
}


function showEmpData($srNo,$empId,$unitName,$regionName,$hqName,$terretory,$fromDate,$toDate){
    global $con;
    $fromDateStart = "2021-04-01";
    
    $toDateEnd = "2022-03-31";
    $empDetail = array();
    $empDetail = getEmployeeDetail($empId);
    $printTable .= "<tr>";
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$srNo .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$unitName .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$regionName .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$hqName .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empRegionName'] .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empName'] .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empDesignation'] .'</td>';
    
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getIcCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getSdCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getSdvCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getFdCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getFmCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getAvCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getRevisitCountEmp($empId,$fromDate,$toDate) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getDealerCountEmp($empId,$fromDate,$toDate) .'</td>';
    
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getIcCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getSdCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getSdvCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getFdCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getFmCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getAvCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getRevisitCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .getDealerCountEmp($empId,$fromDateStart,$toDateEnd) .'</td>';
    $printTable .= "</tr>";
    //echo $printTable;
    return $printTable;
}

function showEmpTabelHeader($regionName){
    global $con;
    $printTable .= '<h3 style="text-align:center">'.$regionName.' Region Activity</h3>';
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th colspan="7" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">'.$regionName.' </th>
                <th colspan="8" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Day Record</th>
                <th colspan="8" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Till Date</th>
            </tr>    
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Zone Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Region Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">HQ Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Territory  Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Employee Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Designation</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">IC</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">SD</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">SDV</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">FD</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">FM</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">AV</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">IC Revisit</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Dealers</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">IC</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">SD</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">SDV</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">FD</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">FM</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">AV</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">IC Revisit</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Dealers</th>
            </tr>
        </thead>
        <tbody>';
        return $printTable;
}

function showEmpTabelFooter(){
    $printTable = "</tbody></table>";
    return $printTable;
}
// ============================================================================================
// ========================== Show Employee wise dealer Data ========================================
// =======================================================================================
function showEmpDealerData($srNo,$setRegionEmpIds,$zoneName,$regionName,$hqName,$trName){
    global $con;
    global $uniqueCounter;
    $empId = $setRegionEmpIds;
    
    $empDetail = array();
    $printTable = '';
    if($empId!=''){
        $agencyDetail = NULL;
        $agencyDetail = getAgencyDetail($empId);
        
        if ($agencyDetail != NULL){
            foreach($agencyDetail as $agencyDetailPrint){
               $printTable .= "<tr>";
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$uniqueCounter .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$zoneName .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$regionName .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$hqName .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$trName .'</td>';
                
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['empRegionName'] .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['empName'] .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['empDesignation'] .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['accountType'] .'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyName'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyShopName'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyMobile'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyTurnover'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['sealerPgrPer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['sellerPN'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyHerbicidePer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyInsecticidePer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['delaerFungicidePer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyGAPLTurnover'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['sealerGAPLPgrPer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['GAPLPN'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyGAPLHerbicidePer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyGAPLInsecticidePer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['delaerGAPLFungicidePer'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyFirstCompanyName'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyFirstCompanyTr'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencySecCompanyName'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencySecCompanyTr'].'</td>';
               $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$agencyDetailPrint['agencyFarmerNetwork'].'</td>';
               $printTable .= "</tr>";
               $uniqueCounter++;
            }
             //echo $printTable;
        }
    }
    return $printTable;
}

//================================ unit header========================
function showEmpDealerUnitTabelHeader($regionName){
    global $con;
    $printTable .= '<h3 style="text-align:center">'.$regionName.' Region Activity</h3>';
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Unit Name</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Employee Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Designation</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Shop Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Mobile</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Address</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">PGR</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total GAVL T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">No of Farmers</th>
            </tr>
        </thead>
        <tbody>';
        return $printTable;
}

// ================================ region header ============================
function showEmpDealerRegionTabelHeader($unitName,$regionName){
    global $con;
    $printTable .= '<h3 style="text-align:center">'.$regionName.' Region Activity</h3>';
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Unit Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Region Name</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Employee Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Designation</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Shop Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Mobile</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Address</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">PGR</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total GAVL T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">No of Farmers</th>
            </tr>
        </thead>
        <tbody>';
        return $printTable;
}

// ==================================== hq header===============================
function showEmpDealerHqTabelHeader($unitName,$regionName,$hqName){
    global $con;
    $printTable .= '<h3 style="text-align:center">'.$regionName.' Region Activity</h3>';
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Unit Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Region Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">HQ Name</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Employee Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Designation</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Shop Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Mobile</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Address</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">PGR</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total GAVL T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">No of Farmers</th>
            </tr>
        </thead>
        <tbody>';
        return $printTable;
}

// ========================= territory =============================================
function showEmpDealerTrTabelHeader($unitName,$regionName,$hqName,$trName){
    global $con;
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Unit</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Region</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">HQ</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Territory</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Market</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Employee Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Designation</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Account Type</th>
                
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Owner Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Shop Name</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Mobile</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">PGR</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Total GAVL T/O (Rs. Lakh)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">PGR</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Plant Nutrition</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Herbicide</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Insecticides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Fungicides</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">First Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Second Company Total (T/O)</th>
				<th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">No of Farmers</th>
            </tr>
        </thead>
        <tbody>';
        return $printTable;
}
?>