<?php
function getAllProductName($productId){
    global $con;
    if($productId == 'All'){
        $queryr="SELECT * FROM `tbl_product` WHERE `liquidationList` = '1' ";
    }else{
        $queryr="SELECT * FROM tbl_product WHERE `pid` IN ($productId)";
    }
    // echo $queryr;
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array('pid'=>$datar['pid'],'productName'=>$datar['productName'],'pidCat'=>$datar['productType']);  
      }
    //   print($arr); 
    return $arr;
} 

function getAllProductsName($productId){
    global $con;
    if($productId == 'All'){
        $queryr="SELECT * FROM `tbl_product` ";
    }else{
        $queryr="SELECT * FROM tbl_product WHERE `pid` IN ($productId)";
    }
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array('pid'=>$datar['pid'],'productName'=>$datar['productName'],'pidCat'=>$datar['productType']);  
      }
    //   print($arr); 
    return $arr;
} 

function getAllCropName($cropId){
    global $con;
    if($cropId == 'All'){
        $queryr="SELECT * FROM `tbl_crop`  ";
    }else{
        $queryr="SELECT * FROM tbl_crop WHERE `cropId` IN ($cropId)";
    }
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array('cropId'=>$datar['cropId'],'cropName'=>$datar['cropName']);  
      }
    //   print($arr); 
    return $arr;
} 

function getRegionNameArray(){ 
    global $con;
    $queryr="SELECT * FROM `tbl_category`";
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array('category_id'=>$datar['category_id'],'category_name'=>$datar['category_name'],'parent_category_id'=>$datar['parent_category_id']);  
      }
    //   print($arr);
    return $arr;
}

function getEmployeeNameArray(){
    global $con;
    $queryr="SELECT *,(SELECT designationName FROM tbl_designation WHERE designationId = t1.empDesignation) as designation_name FROM `tbl_employee` as t1 ORDER BY id";
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array('id'=>$datar['id'],'emp_name'=>$datar['emp_name'],'emp_mobile'=>$datar['emp_mobile'],'designation_id'=>$datar['empDesignation'],'designation_name'=>$datar['designation_name']);  
      }
    //   print($arr);
    return $arr;
}

function getliquidationDetail($regionIds,$productId,$fromDate,$toDate,$agencyType){
    global $con;
    $from = $fromDate;
    $to = $toDate;
    $countCount = 0;
    $dateArray = array();
    $multipleDataArray = array();
    $queryr="SELECT *, MAX(`liId`) AS liId FROM `tbl_liquidation_detail_stock` LEFT JOIN 
            `tbl_agency` ON `tbl_liquidation_detail_stock`.`agencyId` = `tbl_agency`.`agencyId` 
            WHERE `tbl_liquidation_detail_stock`.`agencyRegion` IN ($regionIds) AND `tbl_liquidation_detail_stock`.`productId` = '$productId' 
            AND `tbl_liquidation_detail_stock`.`visitDate` BETWEEN '$from' AND '$to' AND `tbl_agency`.`agencyType`='$agencyType'  GROUP BY 
            `tbl_liquidation_detail_stock`.`agencyId`";
            
    $resultr = $con->query($queryr);
    $agencyVisitId = "";
    $count = mysqli_num_rows($resultr);
    if($count > 0){
        while($datar = $resultr->fetch_assoc()){
            $agencyVisitId .= $datar['liId'].',';
        }
        $agencyVisitId = substr($agencyVisitId,0,-1);
    }
    $getLiquidationIds = $agencyVisitId;
    
    if($getLiquidationIds != ""){
        $sql = "SELECT *  FROM `tbl_liquidation_detail_stock` WHERE `liId` IN ($getLiquidationIds)";
        $result = $con->query($sql);
        $count = mysqli_num_rows($result);
        //echo "<br>";
        
        if($count > 0){
            while($dataCount = $result->fetch_assoc()){
                $dateArray['agencyId'] = $dataCount['agencyId'];
                $dateArray['visitDate'] = $dataCount['visitDate'];
                $dateArray['productId'] = $dataCount['productId'];
                $dateArray['supply'] = $dataCount['supply'];
                $dateArray['remaining'] = $dataCount['remaining'];
                // $dateArray['sold'] = $dataCount['sold'];
                $dateArray['empId'] = $dataCount['empId'];
                $multipleDataArray[] =  $dateArray;
            }
        }
    }
    // echo '<pre>';
    // print_r($multipleDataArray);
    // echo '</pre>';
    return $multipleDataArray;
}

function getliquidationVisitList($regionIds,$fromDate,$toDate,$agencyType){
    global $d;
    global $con;
    $from = $fromDate;
    $to = $toDate;
    $countCount = 0;
    $i = 0; 
    $dateArray = array();
    
    $sqlCount = "SELECT `tbl_agencyvisit`.`agencyId`,`tbl_agency`.`agencyRegion`,
            `tbl_agency`.`agencyShopName`, `tbl_agency`.`distributorCode`, 
            `tbl_agencyvisit`.`empId` FROM `tbl_agencyvisit` 
            LEFT JOIN `tbl_agency` ON `tbl_agencyvisit`.`agencyId` = `tbl_agency`.`agencyId` 
            WHERE `tbl_agencyvisit`.`liquidation` = '1' 
            AND `tbl_agencyvisit`.`visitDate` BETWEEN '$from' AND '$to' 
            AND `tbl_agencyvisit`.`agencyRegion` IN ($regionIds)
            AND `tbl_agency`.`agencyType`='$agencyType'
            GROUP BY `tbl_agencyvisit`.`agencyId`";
    $resultCount = $con->query($sqlCount);
    $countCount = mysqli_num_rows($resultCount);
    
    if($countCount > 0){
        while ($dataCount = $resultCount->fetch_assoc()) {
            $dateArray[$i]['agencyRegion'] = $dataCount['agencyRegion'];
            $dateArray[$i]['distributorCode'] = $dataCount['distributorCode'];
            $dateArray[$i]['agencyId'] = $dataCount['agencyId'];
            $dateArray[$i]['agencyShopName'] = $dataCount['agencyShopName'];
            $dateArray[$i]['empId'] = $dataCount['empId'];
            $i++;
        }
    }
    return $dateArray;
}

function liquidationEmployeeDetail($regionId,$fromDate,$toDate){
    global $con;
    $from = $fromDate;
    $to = $toDate;
    $countCount = 0;
    $employeeDetail = array();
    $employeeDetailArray = array();
    $sql = "SELECT * FROM `tbl_employee` LEFT JOIN `tbl_designation` 
            ON `tbl_designation`.`designationId` = `tbl_employee`.`empDesignation` 
            LEFT JOIN `tbl_category` ON `tbl_category`.`category_id` = `tbl_employee`.`region` 
            WHERE `tbl_employee`.`region` IN ($regionId) 
            AND (`tbl_employee`.`deleteFlag` = 0 OR `tbl_employee`.`deleteDate` >= '$from')
            AND `tbl_employee`.`empDesignation` NOT IN ('24')";//echo "<br>";
    $result =$con->query($sql);
    $countCount = mysqli_num_rows($result);
    
    if($countCount > 0){
        while($data = $result->fetch_assoc()){
            $employeeDetail['empId'] = $data['id'];
            $employeeDetail['edpNum'] = $data['EDP_code'];
            $employeeDetail['empName'] = $data['emp_name'];
            $employeeDetail['empDesignation'] = $data['designationName'];	
            $employeeDetail['regionId'] = $data['region'];
            $employeeDetail['regionName'] = $data['category_name'];
            $employeeDetailArray[] = $employeeDetail;
        }
    }
    return $employeeDetailArray;
}

function showEmpTabelHeader($regionName,$reportDate){
    global $con;
    $productNameArr = getAllProductName();
    $col = count($productNameArr)*4;
    
    $printTable .= '<h3 style="text-align:center">'.$regionName.' REGION</h3>';
    $printTable .= '<h3 style="text-align:center">'.$reportDate.'</h3>';
    $printTable .= '<table style = "font-family: Arial, Helvetica, sans-serif; border-collapse: collapse; width: 100%;">
        <thead>
            <tr>
                <th colspan="8" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">'.$regionName.' </th>
                <th colspan="'.$col.'" style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">LIQUIDATION Record</th>
            </tr>    
            <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Sr.No</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Zone Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Region Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Hq Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Market Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">EDP Num</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Employee Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Name</th>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;">Agency Code</th>
                ';
        
                foreach($productNameArr as $productVal){
                    $printTable .="<th colspan='4'style='padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;' > ".$productVal['productName'] ." </th>";
                } 
                $printTable .="</tr>
                <tr>
                    <th colspan='8' style='padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;'></th>";
              
                    $numcount1 = count($productNameArr);
                    if($numcount1==0){
                        $count=1;
                    }else{
                        $count = $numcount1;
                    }
                    for($v=0;$v<$count;$v++){
                        $printTable .= "
                            <th style='padding-top: 12px; padding-left: 20px;padding-right: 20px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;'>Liq. date</th>
                            <th style='padding-top: 12px; padding-left: 20px;padding-right: 20px; padding-bottom: 12px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;'>Supply</th>
                            <th style='padding-top: 12px; padding-bottom: 12px;padding-left: 20px;padding-right: 20px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd'>Remaining</th>
                            <th style='padding-top: 12px; padding-bottom: 12px;padding-left: 20px;padding-right: 20px; text-align: center; background-color: #04AA6D; color: white;border: 1px solid #ddd;'>Total Sold</th>";
                    } 
                    $printTable .= '
                
                </tr>
            </tr>
        </thead>
        <tbody>';
        return $printTable;
}

function showEmpTabelFooter(){
    $printTable = "</tbody></table>";
    return $printTable;
}

function showLiqTLwise($srNo,$unitName,$regionName,$HqName,$regionId,$regionIds,$fromDate,$toDate){
    global $con;
    global $srNo;
    //$empDetailData = array();
    $empDetailData = getEmployeeDetail($regionIds);
    //print_r($empDetailData);
    foreach($empDetailData as $empDetail){
        $printTable .= "<tr>";
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$srNo++ .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$unitName .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$regionName .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$HqName .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['market'] .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empName'] .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px;">' .$empDetail['empDesignation'] .'</td>';
        $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px; text-align: center">' .getLiquidationVisitCount($empDetail['empId'],$fromDate, $toDate).'</td>';
        
        $productNameArr = getAllProductName();
        foreach($productNameArr as $productVal){
            $productLiquidationData = getLiqidationDetail($productVal['pid'],$empDetail['empId'],$fromDate, $toDate);
            $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px; text-align: center">' .$productLiquidationData['agencyCount'].'</td>';
            $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px; text-align: center">' .$productLiquidationData['productCatSupplyVal'].'</td>';
            $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px; text-align: center">' .$productLiquidationData['productCatStockVal'].'</td>';
            $printTable .= '<td style = "border: 1px solid #ddd; padding: 8px; text-align: center">' .$productLiquidationData['productCatRemainingVal'].'</td>';
        }
        $printTable .= "</tr>";
    }
    //echo $printTable;
    return $printTable;
}

?>