<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/inserLocation.php';

$response = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Activity saved successfully !";
$AlreadyStatusCode = 201;
$AlreadyStatusMsg = "Activity already registered !";
$FailStatusCode = 202;
$FailStatusMsg = "Unable to register !";

try {
    $data = json_decode(file_get_contents("php://input"), true);

    $un = $data['eid'];
    $un1 = (explode("-", $un));
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

    if ($con->connect_error) {
        http_response_code(500);
        $response['status'] = 500;
        $response['error'] = "Database connection failed: " . $con->connect_error;
        echo json_encode($response);
        exit;
    }

    $action = htmlspecialchars(strip_tags($data["action"]));
    $empid = htmlspecialchars(strip_tags($data["empId"]));
    $farmerid = htmlspecialchars(strip_tags($data["farmerId"]));
    $cropId = htmlspecialchars(strip_tags($data["cropId"] ?? ""));
    $productId = htmlspecialchars(strip_tags($data["productId"] ?? ""));
    $fdarea = htmlspecialchars(strip_tags($data["fdarea"] ?? ""));
    $fdproqty = htmlspecialchars(strip_tags($data["productqty"] ?? ""));
    $FD_result = htmlspecialchars(strip_tags($data["FD_result"] ?? ""));
    $FD_date = htmlspecialchars(strip_tags($data["FD_date"] ?? ""));
    $FD_Req_date = htmlspecialchars(strip_tags($data["FD_Req_date"] ?? ""));
    $FD_farmer = htmlspecialchars(strip_tags($data["FD_farmer"] ?? ""));
    $FD_budget = htmlspecialchars(strip_tags($data["FD_budget"] ?? ""));
    $FD_latlong = htmlspecialchars(strip_tags($data["FD_latlong"] ?? ""));
    $faId = htmlspecialchars(strip_tags($data["faId"] ?? ""));
    $accompanedByFD = htmlspecialchars(strip_tags($data["accompanedByFD"] ?? ""));
    $remark = htmlspecialchars(strip_tags($data["FD_remark"] ?? ""));
    $activity_time = htmlspecialchars(strip_tags($data["activity_time"] ?? ""));
    $FD_image = htmlspecialchars(strip_tags($data["FD_image"] ?? ""));
    $battery = isset($data["battery"]) ? htmlspecialchars(strip_tags($data["battery"])) : 0;
    $deviceToken = isset($data["deviceToken"]) ? htmlspecialchars(strip_tags($data["deviceToken"])) : '';

    if ($action == "add") {
        if (!empty($data["farmerId"]) && !empty($data["empId"])) {
            $sql_status = "SELECT `fd_auto_approval` FROM `tbl_updatekeynew` WHERE `id` = 1";
            $query_status = mysqli_query($con, $sql_status);
            $row_status = mysqli_fetch_array($query_status);
            $fd_auto_approval = $row_status["fd_auto_approval"];

            $sqlCheck = "SELECT * FROM tbl_farmactivityFD WHERE `farmerId` = '$farmerid' AND `productId` = '$productId' AND `FD_Req_Date` = '$FD_Req_date' AND `empId` = '$empid'";
            $resultCheck = mysqli_query($con, $sqlCheck);
            $numrows = mysqli_num_rows($resultCheck);

            if ($numrows == 0) {
                $sql2 = "INSERT INTO `tbl_farmactivityFD`
                    (`farmerId`, `cropId`, `productId`, `FD_Area`, `FD_ProductQty`, `FD_result`, `FD_Req_Date`, `FD_farmerNum`, `FD_budget`, `empId`, `fd_latlong`, `accompanedByFD`, `remark`, `approvstatus`, `activity_time`)
                    VALUES ('$farmerid','$cropId', '$productId', '$fdarea', '$fdproqty', '$FD_result','$FD_Req_date', '$FD_farmer','$FD_budget','$empid','$FD_latlong','$accompanedByFD','$remark','$fd_auto_approval','$activity_time')";
                $query2 = mysqli_query($con, $sql2);

                if ($query2) {
                    $faId = mysqli_insert_id($con);
                    $response['faId'] = $faId;
                    $response['status'] = $SuccessStatusCode;
                    $response['message'] = $SuccessStatusMsg;

                    mysqli_query($con, "UPDATE `tbl_farmer` SET `farmerFD`='1' WHERE `farmerId` ='$farmerid'");
                    mysqli_query($con, "UPDATE `tbl_updatekeynew` SET `FDList`= FDList+1 WHERE `id`=1");
                } else {
                    $response['status'] = $FailStatusCode;
                    $response['message'] = $FailStatusMsg;
                }
            } else {
                $response['status'] = $AlreadyStatusCode;
                $response['message'] = $AlreadyStatusMsg;
            }
        } else {
            $response['status'] = 201;
            $response['message'] = "Missing required data";
        }

    } else if ($action == "update") {
        $FDId = htmlspecialchars(strip_tags($data["FDId"]));
        $Actualbudget = htmlspecialchars(strip_tags($data["ActualBudget"]));
        $Actualfarmno = htmlspecialchars(strip_tags($data["ActualFarmNo"]));

        $sql12 = "UPDATE `tbl_farmactivityFD` 
            SET 
            `FD_result`= '$FD_result',
            `FD_date`= '$FD_date',
            `Actual_Farmerno`= '$Actualfarmno',
            `Actual_Budget`= '$Actualbudget', 
            `empId`= '$empid',
            `fd_latlong`= '$FD_latlong',
            `accompanedByFD`= '$accompanedByFD',
            `remark`= '$remark',
            `FD_image` = '$FD_image',
            `approvstatus`= '3' 
            WHERE 
            `fafdId`= '$FDId'";
        $query12 = mysqli_query($con, $sql12);

        if ($accompanedByFD) {
            $accompainedEmp = explode("#", $accompanedByFD);
            foreach ($accompainedEmp as $accompainedEmpVal) {
                mysqli_query($con, "INSERT INTO `tbl_activity_accompained_emp` (`activityId`, `empId`, `activityDate`, `activity_time`, `activityType`) 
                    VALUES ('$FDId','$accompainedEmpVal','$FD_date','$activity_time','4')");
            }
        }

        mysqli_query($con, "UPDATE `tbl_activity_count_current_year` 
            SET `fd`= fd+1
            WHERE `empId`= $empid AND `activityDate` = '$FD_date'");

        $activityLatLongArr = explode("#", $FD_latlong);
        $lat = $activityLatLongArr[0] ?? "";
        $long = $activityLatLongArr[1] ?? "";

        $sqlBeatCheck = mysqli_query($con, "SELECT * FROM tbl_beat_planning WHERE customerType = '1' AND farmerActivityType = '4' AND clientId = '$farmerid' AND date = '$FD_date' AND activity_time = '$activity_time' AND empId = '$empid'");
        if (mysqli_num_rows($sqlBeatCheck) == 0) {
            mysqli_query($con, "INSERT INTO `tbl_beat_planning`
                (`customerType`, `farmerActivityType`, `clientId`, `newRegistration`, `date`, `activity_time`, `empId`, `latlong`,`performedStatus`)
                VALUE ('1','4','$farmerid','$villageId','$FD_date','$activity_time','$empid','$FD_latlong','1')");
        }

        insertLocationData($con, $lat, $long, $activity_time, $battery, $empid, $un, $FD_date, $deviceToken, $FDId, '4');

        $response['status'] = $query12 ? 200 : 201;
        $response['message'] = $query12 ? "Success" : "Failed";

    } else {
        $response['status'] = 201;
        $response['message'] = "Invalid action";
    }

} catch (Exception $e) {
    http_response_code(500);
    $response['status'] = 500;
    $response['error'] = "Internal Server Error: " . $e->getMessage();
}

echo json_encode($response);
?>
