<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = array();
$activityTarget = array();
$activityTargetAchieve = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$FailStatusCode = 202;
$FailStatusMsg = "Credentials Incorrect!";

$data = json_decode(file_get_contents("php://input"), true);

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

$empId = $data['empId'];
$fromDate  = date('Y-m-01');
$toDate = date('Y-m-d', strtotime('last day of +0 month'));

$sql = "SELECT 
            * 
        FROM 
            tbl_activity_target 
        WHERE 
            empId = '$empId' 
        AND 
            date_from = '$fromDate' 
        AND 
            date_to = '$toDate'";
$query = mysqli_query($con, $sql);
if(mysqli_num_rows($query) > 0){
    while ($row = mysqli_fetch_array($query)) {
        array_push($activityTarget, array(
            "ic" => $row['icTarget'],
            "sd" => $row['sdTarget'],
            "fd" => $row['fdTarget'],
            "fm" => $row['organisedMeetingTarget']+$row['groupMeetingTarget'],
            "organisedMeetingTarget" => $row['organisedMeetingTarget'],
            "groupMeetingTarget" => $row['groupMeetingTarget'],
            "revisit" => $row['revisit']
        ));
    }
}else{
    array_push($activityTarget, array(
        "ic" => null,
        "sd" => null,
        "fd" => null,
        "fm" => null,
        "organisedMeetingTarget" => null,
        "groupMeetingTarget" => null,
        "revisit" => null
    ));
}

$sqlAchieve = "SELECT
            SUM(tat.ic) AS ic_achieved,
            SUM(tat.revisit) AS revisit_achieved,
            SUM(tat.sd) AS sd_achieved,
            SUM(tat.fd) AS fd_achieved,
            SUM(tat.fm) AS fm_achieved,
            SUM(tat.ofm) AS ofm_achieved,
            SUM(tat.gfm) AS gfm_achieved,
            SUM(tat.av) AS av_achieved
        FROM 
            tbl_activity_count_current_year AS tat
        WHERE 
            tat.activityDate BETWEEN '$fromDate' AND '$toDate'
        AND 
            empId = '$empId' ";
$queryAchieve = mysqli_query($con, $sqlAchieve);

while ($row = mysqli_fetch_array($queryAchieve)) {
    array_push($activityTargetAchieve, array(
        "ic" => $row['ic_achieved'],
        "sd" => $row['sd_achieved'],
        "fd" => $row['fd_achieved'],
        "fm" => $row['fm_achieved'],
        "organisedMeetingTarget" => $row['ofm_achieved'],
        "groupMeetingTarget" => $row['gfm_achieved'],
        "revisit" => $row['revisit_achieved']
    ));
}

$response['status'] = $SuccessStatusCode;
$response['message'] = $SuccessStatusMsg;
$response['activityCardTitle'] = date('d M Y', strtotime($fromDate)).' - '.date('d M Y', strtotime($toDate));
$response['activityTarget'] = $activityTarget;
$response['activityTargetAchieve'] = $activityTargetAchieve;

http_response_code(200);
echo json_encode($response);
?>
