<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once '../../db_config/config1.php';

// Read JSON input
$data = json_decode(file_get_contents("php://input"), true);

// Check if JSON is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(["status" => "error", "message" => "Invalid JSON format"]);
    exit;
}

// Check for required fields
$requiredFields = ['eid', 'activity_time', 'empId', 'activityId', 'activityLatLong', 'visitId', 'agencyId', 'visit_status', 'punch_in'];
foreach ($requiredFields as $field) {
    if (!isset($data[$field])) {
        echo json_encode(["status" => "error", "message" => "Missing required data: $field"]);
        exit;
    }
}

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];

$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if ($con->connect_error) {
    $response['status'] = 'error';
    $response['message'] = 'Database connection error: ' . $con->connect_error;
    echo json_encode($response);
    exit;
}

// Sanitize inputs
$activity_time = htmlspecialchars(strip_tags($data["activity_time"]));
$empId = htmlspecialchars(strip_tags($data["empId"]));
$activityId = htmlspecialchars(strip_tags($data["activityId"]));
$activityLatLong = htmlspecialchars(strip_tags($data["activityLatLong"]));
$punch_in = htmlspecialchars(strip_tags($data["punch_in"]));

$activityLatLongArr = explode("#", $activityLatLong);
if (count($activityLatLongArr) != 2) {
    echo json_encode(["status" => "error", "message" => "Invalid Lat-Long format"]);
    exit;
}
$lat = $activityLatLongArr[0];
$long = $activityLatLongArr[1];

$battery = htmlspecialchars(strip_tags($data['battery']));
$date = htmlspecialchars(strip_tags($data['date']));
$deviceToken = htmlspecialchars(strip_tags($data['deviceToken']));
$visitId = intval($data['visitId']); // Ensure it's an integer
$agencyId = htmlspecialchars(strip_tags($data['agencyId']));
$visit_status = intval($data['visit_status']); // Ensure it's an integer

// Insert location data function (Assuming it's defined in config1.php)
if (function_exists('insertLocationData')) {
    insertLocationData($con, $lat, $long, $activity_time, $battery, $empId, '', $date, $deviceToken, $activityId, '');
}

// Query to check if the visit exists
$query = "SELECT * FROM tbl_agencyvisit WHERE visitId = ? AND empId = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("is", $visitId, $empId); // Correct data type (i = integer, s = string)
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $punch_in_db = $row['punch_in'];
    $punch_out = $row['punch_out'];

    if ($visit_status == 0) { // On location
        if (empty($punch_in_db)) {
            $update_query = "UPDATE tbl_agencyvisit SET punch_in = ? WHERE visitId = ?";
            $update_stmt = $con->prepare($update_query);
            $update_stmt->bind_param("si", $punch_in, $visitId);
            $update_stmt->execute();
        }

       if (!empty($activity_time)) {
            $update_query = "UPDATE tbl_agencyvisit SET last_ping = ? WHERE visitId = ?";
            $update_stmt = $con->prepare($update_query);
            $update_stmt->bind_param("si", $activity_time, $visitId);
            $update_stmt->execute();
        } else {
            error_log("Skipping last_ping update due to empty activity_time");
        }

        echo json_encode(["status" => "success", "message" => "Location updated successfully.", "visitId" => $visitId, "visit_status" => $visit_status]);
    } 
    else if ($visit_status == 1) { // Out of location
        $punch_out_time = $activity_time;
        $activity_time_diff = strtotime($punch_out_time) - strtotime($punch_in_db);
        $activity_time_diff = gmdate("H:i:s", $activity_time_diff); 

        $update_query = "UPDATE agencyvisit SET punch_out = ?, activity_time = ?, visit_status = ? WHERE visitId = ?";
        $update_stmt = $con->prepare($update_query);
        $update_stmt->bind_param("ssii", $punch_out_time, $activity_time_diff, $visit_status, $visitId);
        $update_stmt->execute();

        echo json_encode(["status" => "success", "message" => "Visit marked as completed.", "visitId" => $visitId, "visit_status" => $visit_status, "activity_time" => $activity_time_diff]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Visit not found for the given visitId and empId"]);
}

$con->close();
?>