<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../db_config/config1.php';
include_once '../functions/getIds.php';
//$data = array();
 
$agencyArray = [];
$agencyDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["empId"])&& !empty($data["page"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    $getRegionNameArray = getRegionNameArray($con);
    $empid = $data["empId"];
    
    $itemsPerPage = 1000; 
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = $empid AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $desig = $row1["empDesignation"];
    $region = $row1["region"];

    $row = getRegionId($con,$region);

    $sql = "SELECT t1.*, t1.agencyShopName as agencyDistributorName,t5.designation_name
            FROM `tbl_agency` t1 
            LEFT JOIN tbl_agency_designation t5 ON t1.designation = t5.id
            WHERE t1.`agencyRegion` IN ($row) 
            AND t1.approvstatus = 1";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t1.agencyShopName LIKE '%$search%' 
                  OR t1.agencyMobile LIKE '%$search%' 
                  OR t1.agencyAddress LIKE '%$search%' 
                  )";
    }
    
    $sql .= " ORDER BY t1.agencyShopName ASC LIMIT $itemsPerPage OFFSET $offset";
    //exit;
    $query111 = mysqli_query($con, $sql);
    //exit;
    $rowCount111 = mysqli_num_rows($query111);

    if ($query111) {
        if ($rowCount111 > 0) {
            while ($row = mysqli_fetch_array($query111)) {
                $regionName = '';
                if($row['agencyRegion']){
                    $key = '';
                    $key = array_search($row['agencyRegion'], array_column($getRegionNameArray, 'category_id'));
                    if ($key === FALSE) {
                        $regionName = '';
                    } else {
                        $regionName = $getRegionNameArray[$key]['category_name'];
                    }
                }
        
                $geofence_radius= isset($row["geofence_radius"]) ? $row["geofence_radius"] : 0;
                $agencyLatLong = isset($row["agencyLocation"]) ? $row["agencyLocation"] : null;
                // $visitStatus = isset($row["visit_status"]) ? $row["visit_status"] : "1";  
                 
                 // Step 4: Check visit status for each agency based on empId and agencyId
                $visitStatus = "0";  
                $sqlVisit = "SELECT visit_status 
                             FROM tbl_agencyvisit 
                             WHERE empId = $empid 
                             AND agencyId = " . $row['agencyId'] . " 
                             AND visitDate = CURDATE()"; // Using today's date
                $queryVisit = mysqli_query($con, $sqlVisit);
                
                if ($queryVisit && mysqli_num_rows($queryVisit) > 0) {
                    $visitRow = mysqli_fetch_array($queryVisit);
                    $visitStatus = $visitRow['visit_status']; 
                
                    // Toggle visit status
                    if ($visitStatus == "0") {
                        $visitStatus = "1";
                    } else {
                        $visitStatus = "0";
                    }
                }
   
                array_push(
                    $agencyArray,
                    array(
                        "agencyId" => htmlspecialchars(strip_tags($row["agencyId"])),
                        "siteName" => htmlspecialchars(strip_tags($row["agencyShopName"])),
                        "agencyAddress" => htmlspecialchars(strip_tags($row["agencyAddress"])),
                        "agencyCity" => htmlspecialchars(strip_tags($row["agencyCity"])),
                        "agencyPincode" => htmlspecialchars(strip_tags($row["agencyPincode"])),
                        "regionName" => $regionName,
                        "agencyRegion" => htmlspecialchars(strip_tags($row["agencyRegion"])),
                        "geofence_radius" => htmlspecialchars(strip_tags($row["geofence_radius"])),
                        "agencyLatLong" => $agencyLatLong,
                        "visitStatus" => $visitStatus 
                    )
                );
                       
            }

            $response['agencyList'] = $agencyArray;
            $response['rowCount'] = $rowCount111;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
