<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../db_config/config1.php';

$response = [];
$data1 = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Data fetched successfully!";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['eid']) || strpos($data['eid'], "-") === false) {
    $response['status'] = $FailStatusCode;
    $response['message'] = "Invalid or missing 'eid' value.";
    echo json_encode($response);
    exit;
}

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if ($con->connect_error) {
    die(json_encode([
        "status" => 500,
        "message" => "Database Connection Failed: " . $con->connect_error
    ]));
}

// **Modified SQL query to fetch all visit records**
$sql1 = "SELECT tbl_daystart.id AS daystart_id, tbl_daystart.date, tbl_daystart.stime, tbl_daystart.etime
         FROM tbl_daystart
         LEFT JOIN tbl_employee ON tbl_employee.id = tbl_daystart.uid";

$query1 = mysqli_query($con, $sql1);

if ($query1) {
    $count1 = mysqli_num_rows($query1);
} else {
    $count1 = 0;
}

if ($count1 > 0) {
    while ($row = mysqli_fetch_array($query1)) {
       // Convert stime and etime to timestamps
        $stime = strtotime($row["stime"]);
        $etime = strtotime($row["etime"]);
        
        // Calculate duration in seconds
        $duration = $etime - $stime;

        // Format duration as H:i:s (hours:minutes:seconds)
        $activityTime = gmdate("H:i:s", $duration);
        array_push($data1, [
             "id" => $row["daystart_id"], 
            "date" => $row["date"],
            "stime" => $row["stime"],
            "etime" => $row["etime"],
            "activitytime" => $activityTime
        ]);
    }
    $response['status'] = $SuccessStatusCode;
    $response['message'] = $SuccessStatusMsg;
    $response['details'] = $data1;
} else {
    http_response_code(400);
    $response['status'] = $noDataFoundcode;
    $response['message'] = $noDataFoundMsg;
}

echo json_encode($response);
?>
