<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../db_config/config1.php';

$response = [];
$data1 = [];
// $agencyData = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Data fetched successfully!";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to fetch the list.";

$data = json_decode(file_get_contents("php://input"), true);

file_put_contents("debug_log.txt", date("Y-m-d H:i:s") . " - Received Data: " . json_encode($data) . PHP_EOL, FILE_APPEND);

if (!isset($data['empId'])) {
    $response['status'] = $FailStatusCode;
    $response['message'] = "Missing 'empId' value.";
    echo json_encode($response);
    exit;
}

if (!isset($data['visitdate'])) {
    $response['status'] = $FailStatusCode;
    $response['message'] = "Missing 'visitdate' value.";
    echo json_encode($response);
    exit;
}

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if ($con->connect_error) {
    die(json_encode([
        "status" => 500,
        "message" => "Database Connection Failed: " . $con->connect_error
    ]));
}

$employee_id = $data['empId'];
$requestDate = $data['visitdate'];

// New query using dynamic visitdate and empId from request data
$sql = "SELECT 
    tbl_agencyvisit.empId AS employee_id, 
    tbl_agencyvisit.visitId AS visit_id, 
    tbl_agencyvisit.visitDate, 
    tbl_agencyvisit.punch_in, 
    tbl_agencyvisit.punch_out, 
    tbl_agencyvisit.totalTimeSpent, 
    tbl_agency.agencyId, 
    tbl_agency.agencyName
FROM tbl_agencyvisit
INNER JOIN tbl_employee ON tbl_employee.id = tbl_agencyvisit.empId
INNER JOIN tbl_agency ON tbl_agency.agencyId = tbl_agencyvisit.agencyId
WHERE tbl_agencyvisit.visitDate = ?
AND tbl_agencyvisit.empId = ?"; 

$stmt = $con->prepare($sql);
$stmt->bind_param("ss", $requestDate, $employee_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result) {
    $count = $result->num_rows;
} else {
    $count = 0;
}

if ($count > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($data1, [
            "employee_id" => $row["employee_id"],
            "visit_id" => $row["visit_id"],
            "visit_date" => $row["visitDate"],
            "punch_in" => $row["punch_in"],
            "punch_out" => $row["punch_out"],
            "total_time_spent" => $row["totalTimeSpent"],
            "agencyName" => $row["agencyName"]
        ]);
        
        // $agencyData[] = $row;
    }
    $response['status'] = $SuccessStatusCode;
    $response['message'] = $SuccessStatusMsg;
    $response['details'] = $data1;
    // $response['agencies'] = $agencyData;
} else {
    $response['status'] = $noDataFoundcode;
    $response['message'] = $noDataFoundMsg;
}

file_put_contents("debug_log.txt", date("Y-m-d H:i:s") . " - SQL Executed: $sql | Rows Found: $count" . PHP_EOL, FILE_APPEND);

echo json_encode($response);

$stmt->close();
$con->close();
?>
