<?php
// // Enable error reporting for debugging (disable in production)
// // ini_set('display_errors', 1);
// // error_reporting(E_ALL);

// // Set necessary headers
// header("Access-Control-Allow-Origin: *");
// header("Content-Type: application/json; charset=UTF-8");
// header("Access-Control-Allow-Methods: POST");
// header("Access-Control-Max-Age: 3600");
// header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// require_once '../../db_config/config1.php';
// include_once '../functions/inserLocation.php';

// // Status codes and messages
// define('SUCCESS_STATUS', 200);
// define('SUCCESS_MSG_IN', "Activity Punched IN successfully!");
// define('SUCCESS_MSG_OUT', "Activity Punched OUT successfully!");
// define('FAIL_STATUS', 202);
// define('FAIL_MSG', "Activity cannot be saved !");

// // Read and validate incoming data
// $data = json_decode(file_get_contents("php://input"), true);

// if (!empty($data["agencyId"]) && !empty($data["empId"])) {
    
//     $un = $data["eid"];
//     $un1 = (explode("-", $un));
//     $un2 = $base_dbname . $un1[0];
//     $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

//     if ($con->connect_error) {
//         http_response_code(500);
//         echo $response['message'] = "Database connection failed!";
//         echo json_encode($response);
//         exit;
//     }

//     // Sanitized input
//     $visitDate = $con->real_escape_string($data["visitDate"]);
//     $agencyId = $con->real_escape_string($data["agencyId"]);
//     $empId = $con->real_escape_string($data["empId"]);
//     $latlong = $con->real_escape_string($data["latlong"]);
//     $agencyRegion = $con->real_escape_string($data["agencyRegion"]);
//     $visitId = $con->real_escape_string($data["visitId"]);
//     $visitStatus = $con->real_escape_string($data["visitStatus"]);
//     $battery = isset($data["battery"]) ? htmlspecialchars(strip_tags($data["battery"])) : 0;
//     $deviceToken = isset($data["deviceToken"]) ? htmlspecialchars(strip_tags($data["deviceToken"])) : '';
//     $activity_time = $con->real_escape_string($data["activity_time"]);
//     $agencyType = 2;

//     $purpose = '1';
//     $aVisitPhoto_key = 'NA';
//     $remark = 'NA';

//     // **Always insert a new visit (no duplicate check)**
//     try {
//         if ($visitId == null && isset($agencyId) && $visitStatus == 0) {
//             $insertSql = "
//                 INSERT INTO `tbl_agencyvisit` (
//                     `visitDate`, `empId`, `agencyId`, `agencyRegion`, `agencyType`, 
//                     `latlong`, `punch_in`, `last_ping`, `visit_status`, `activity_time`,
//                     `purpose`, `aVisitPhoto_key`, `remark`
//                 ) VALUES ('$visitDate', '$empId', '$agencyId', '$agencyRegion', $agencyType, 
//                     '$latlong', '$activity_time', '$activity_time', '$visitStatus', '$activity_time',
//                     '$purpose', '$aVisitPhoto_key', '$remark')";
            
//             if ($con->query($insertSql)) {
//                 $visitId = $con->insert_id;
    
//                 // Update tbl_track
//                 $activityLatLong = str_replace("#", "/", $latlong);
//                 $activityGeotagVal = "#{$activityLatLong}/{$activity_time}/6/{$visitId}";
            
//                 $updateTrackSql = "
//                         UPDATE tbl_track 
//                     SET 
//                         activityGeotag = CONCAT(activityGeotag, '$activityGeotagVal'),
//                         lltb = '$activityLatLong'
//                     WHERE 
//                         eid = '$un' 
//                     AND 
//                         date = '$visitDate'";
//                 $con->query($updateTrackSql);
                
//                 // $sqlUpdateCount = "UPDATE `tbl_activity_count_current_year` 
//                 //                     SET `av`= av+1
//                 //                     WHERE `empId`= $empId
//                 //                     AND `activityDate` = '$activity_time'";
//                 // $con->query($sqlUpdateCount);
                
//                 $sqlUpdateAgency = "UPDATE `tbl_agency` 
//                                 SET 
//                                     `lastVisitDateTime`= '$visitDate' 
//                                 WHERE 
//                                     `agencyId`= '$agencyId'";
//                 $con->query($sqlUpdateAgency);
            
//                 $activityLatLongArr = explode("#", $latlong);
//                 $lat = $activityLatLongArr[0];
//                 $long = $activityLatLongArr[1];
                
//                 // Insert location data
//                 insertLocationData($con, $lat, $long, $activity_time, $battery, $empId, $un, $visitDate, $deviceToken, $visitId, '6');
            
//                 // Success response
//                 $response = [
//                     'status' => SUCCESS_STATUS,
//                     'message' => SUCCESS_MSG_IN,
//                     'visitId' => $visitId
//                 ];
//                 http_response_code(SUCCESS_STATUS);
//             } else {
//                 http_response_code(503);
//                 $response['message'] = "Database query failed: " . $con->error;
//             }
//         }
//     } catch (Exception $e) {
//         http_response_code(400);
//         $response['message'] = "An error occurred: " . $e->getMessage();  
//     }


//     // Handle existing visitId and punch-out logic
//     try {
//         if (isset($visitId) && isset($agencyId) && $visitStatus == 1) {
//             $sqlAV = "SELECT * FROM tbl_agencyvisit 
//                       WHERE `agencyId` = '$agencyId' 
//                       AND `empId` = '$empId' 
//                       AND `visitId` = '$visitId' 
//                       AND `visitDate` = '$visitDate'
//                       AND `visit_status` = 0";
            
//             $resultAV = $con->query($sqlAV);
//             $numrowsAV = $resultAV->num_rows;
            
//             if ($numrowsAV != 0) {
//                 $dataAV = $resultAV->fetch_object();
//                 $punch_in = $con->real_escape_string($dataAV->punch_in);
                
//                 // Convert strings to DateTime objects
//                 $punchInTime = new DateTime($punch_in);
//                 $activityTime = new DateTime($activity_time);
                
//                 // Calculate the difference
//                 $interval = $punchInTime->diff($activityTime);
                
//                 // Format output as HH:MM:SS
//                 $timeSpent = $interval->format('%H:%I:%S');
                
//                 $timespanHr = $interval->format('%H');
//                 $timespanMin = $interval->format('%I');
                
//                 $sql = "UPDATE `tbl_agencyvisit` 
//                         SET `hrTime` = '$timespanHr',
//                             `mTime` = '$timespanMin',
//                             `last_ping` = '$activity_time',
//                             `punch_out` = '$activity_time',
//                             `totalTimeSpent` = '$timeSpent',
//                             `visit_status` = $visitStatus
//                         WHERE `visitId` = '$visitId' AND `agencyId` = '$agencyId'";
                
//                 if ($con->query($sql)) {
//                     // Update tbl_updatekeynew
//                     $updateKeySql = "UPDATE `tbl_updatekeynew` 
//                                      SET `distributorVisitList` = distributorVisitList + 1 
//                                      WHERE `id` = 1";
//                     $con->query($updateKeySql);
            
//                     $response['status'] = SUCCESS_STATUS;
//                     $response['message'] = SUCCESS_MSG_OUT;
//                     $response['visitId'] = $visitId;
//                 } else {
//                     $response['status'] = FAIL_STATUS;
//                     $response['message'] = FAIL_MSG;
//                 }
//             }
//         }
//     } catch (Exception $e) {
//         http_response_code(400);
//         $response['message'] = "An error occurred: " . $e->getMessage();
//     }
        
// } else {
//     http_response_code(400);
//     $response['message'] = "Invalid input data!";
// }
// Enable error reporting for debugging (disable in production)
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

// Set necessary headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once '../../db_config/config1.php';
include_once '../functions/inserLocation.php';

// Status codes and messages
define('SUCCESS_STATUS', 200);
define('SUCCESS_MSG_IN', "Activity Punched IN successfully!");
define('SUCCESS_MSG_OUT', "Activity Punched OUT successfully!");
define('FAIL_STATUS', 202);
define('FAIL_MSG', "Activity cannot be saved !");
define('EXISTING_VISIT_MSG', "Already existing");

// Read and validate incoming data
$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["agencyId"]) && !empty($data["empId"])) {
    
    $un = $data["eid"];
    $un1 = (explode("-", $un));
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

    if ($con->connect_error) {
        http_response_code(500);
        echo json_encode(['message' => "Database connection failed!"]);
        exit;
    }

    // Sanitized input
    $visitDate = $con->real_escape_string($data["visitDate"]);
    $agencyId = $con->real_escape_string($data["agencyId"]);
    $empId = $con->real_escape_string($data["empId"]);
    $latlong = $con->real_escape_string($data["latlong"]);
    $agencyRegion = $con->real_escape_string($data["agencyRegion"]);
    $visitId = $con->real_escape_string($data["visitId"]);
    $visitStatus = $con->real_escape_string($data["visitStatus"]);
    $battery = isset($data["battery"]) ? htmlspecialchars(strip_tags($data["battery"])) : 0;
    $deviceToken = isset($data["deviceToken"]) ? htmlspecialchars(strip_tags($data["deviceToken"])) : '';
    $activity_time = $con->real_escape_string($data["activity_time"]);
    $agencyType = 2;

    $purpose = '1';
    $aVisitPhoto_key = 'NA';
    $remark = 'NA';

    // **Validation: Check if there's already an existing visit for this employee and date**
    if ($visitStatus == 0) {
        // Check if an existing visit with status 0 exists for the given employee and visitDate
        $checkVisitSql = "SELECT * FROM tbl_agencyvisit WHERE empId = '$empId' AND visitDate = '$visitDate' AND visit_status = 0";
        $resultCheckVisit = $con->query($checkVisitSql);
        
        if ($resultCheckVisit->num_rows > 0) {
            // Existing visit found with status 0, return 'Already existing' message
            $response = [
                'status' => FAIL_STATUS,
                'message' => EXISTING_VISIT_MSG
            ];
            http_response_code(FAIL_STATUS);
            echo json_encode($response);
            exit; // Stop further execution
        }
    }

    // Proceed with insertion only if validation passes
    try {
        if ($visitId == null && isset($agencyId) && $visitStatus == 0) {
            $insertSql = "
                INSERT INTO `tbl_agencyvisit` (
                    `visitDate`, `empId`, `agencyId`, `agencyRegion`, `agencyType`, 
                    `latlong`, `punch_in`, `last_ping`, `visit_status`, `activity_time`,
                    `purpose`, `aVisitPhoto_key`, `remark`
                ) VALUES ('$visitDate', '$empId', '$agencyId', '$agencyRegion', $agencyType, 
                    '$latlong', '$activity_time', '$activity_time', '$visitStatus', '$activity_time',
                    '$purpose', '$aVisitPhoto_key', '$remark')";
            
            if ($con->query($insertSql)) {
                $visitId = $con->insert_id;
    
                // Update tbl_track
                $activityLatLong = str_replace("#", "/", $latlong);
                $activityGeotagVal = "#{$activityLatLong}/{$activity_time}/6/{$visitId}";
            
                $updateTrackSql = "
                        UPDATE tbl_track 
                    SET 
                        activityGeotag = CONCAT(activityGeotag, '$activityGeotagVal'),
                        lltb = '$activityLatLong'
                    WHERE 
                        eid = '$un' 
                    AND 
                        date = '$visitDate'";
                $con->query($updateTrackSql);
                
                $sqlUpdateAgency = "UPDATE `tbl_agency` 
                                SET 
                                    `lastVisitDateTime`= '$visitDate' 
                                WHERE 
                                    `agencyId`= '$agencyId'";
                $con->query($sqlUpdateAgency);
            
                // Insert location data
                insertLocationData($con, $lat, $long, $activity_time, $battery, $empId, $un, $visitDate, $deviceToken, $visitId, '6');
            
                // Success response
                $response = [
                    'status' => SUCCESS_STATUS,
                    'message' => SUCCESS_MSG_IN,
                    'visitId' => $visitId
                ];
                http_response_code(SUCCESS_STATUS);
            } else {
                http_response_code(503);
                $response['message'] = "Database query failed: " . $con->error;
                echo json_encode($response);
            }
        }
    } catch (Exception $e) {
        http_response_code(400);
        $response['message'] = "An error occurred: " . $e->getMessage();  
        echo json_encode($response);
    }
        
    // Handle existing visitId and punch-out logic
    try {
        if (isset($visitId) && isset($agencyId) && $visitStatus == 1) {
            $sqlAV = "SELECT * FROM tbl_agencyvisit 
                      WHERE `agencyId` = '$agencyId' 
                      AND `empId` = '$empId' 
                      AND `visitId` = '$visitId' 
                      AND `visitDate` = '$visitDate'
                      AND `visit_status` = 0";
            
            $resultAV = $con->query($sqlAV);
            $numrowsAV = $resultAV->num_rows;
            
            if ($numrowsAV != 0) {
                $dataAV = $resultAV->fetch_object();
                $punch_in = $con->real_escape_string($dataAV->punch_in);
                
                // Convert strings to DateTime objects
                $punchInTime = new DateTime($punch_in);
                $activityTime = new DateTime($activity_time);
                
                // Calculate the difference
                $interval = $punchInTime->diff($activityTime);
                
                // Format output as HH:MM:SS
                $timeSpent = $interval->format('%H:%I:%S');
                
                $timespanHr = $interval->format('%H');
                $timespanMin = $interval->format('%I');
                
                $sql = "UPDATE `tbl_agencyvisit` 
                        SET `hrTime` = '$timespanHr',
                            `mTime` = '$timespanMin',
                            `last_ping` = '$activity_time',
                            `punch_out` = '$activity_time',
                            `totalTimeSpent` = '$timeSpent',
                            `visit_status` = $visitStatus
                        WHERE `visitId` = '$visitId' AND `agencyId` = '$agencyId'";
                
                if ($con->query($sql)) {
                    // Update tbl_updatekeynew
                    $updateKeySql = "UPDATE `tbl_updatekeynew` 
                                     SET `distributorVisitList` = distributorVisitList + 1 
                                     WHERE `id` = 1";
                    $con->query($updateKeySql);
            
                    $response['status'] = SUCCESS_STATUS;
                    $response['message'] = SUCCESS_MSG_OUT;
                    $response['visitId'] = $visitId;
                } else {
                    $response['status'] = FAIL_STATUS;
                    $response['message'] = FAIL_MSG;
                }
            }
        }
    } catch (Exception $e) {
        http_response_code(400);
        $response['message'] = "An error occurred: " . $e->getMessage();
    }
        
} else {
    http_response_code(400);
    $response['message'] = "Invalid input data!";
}

echo json_encode($response);
?>
