<?php
//error_log('Incoming $_POST: ' . print_r($_POST, true));
//error_log('Incoming $_FILES: ' . print_r($_FILES, true));

// error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 30");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include necessary files
include_once '../db_config/config1.php';
include_once 'functions/inserLocation.php';

// Retrieve and decode the JSON data from the request
$data = json_decode(file_get_contents("php://input"), true);
// print_r($data);
if (!isset($data['eid'], $data['activity_time'], $data['empId'], $data['date'], $data['activityLatLong'])) {
    $response['status'] = 'error';
    $response['message'] = 'Missing required data';
    echo json_encode($response);
    exit;
}

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];

$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if ($con->connect_error) {
    $response['status'] = 'error';
    $response['message'] = 'Database connection error: ' . $con->connect_error;
    echo json_encode($response);
    exit;
}

$activity_time = htmlspecialchars(strip_tags($data["activity_time"]));
$empId = htmlspecialchars(strip_tags($data["empId"]));
$date = htmlspecialchars(strip_tags($data["date"]));
$activityId = htmlspecialchars(strip_tags($data["activityId"]));
$activityLatLong = htmlspecialchars(strip_tags($data["activityLatLong"]));

$battery = isset($data["battery"]) ? htmlspecialchars(strip_tags($data["battery"])) : 0;
$deviceToken = isset($data["deviceToken"]) ? htmlspecialchars(strip_tags($data["deviceToken"])) : '';

//  latitude and longitude from activityLatLong
$activityLatLongArr = explode("#", $activityLatLong);
$lat = $activityLatLongArr[0];
$long = $activityLatLongArr[1];

// Call the insertLocationData function
$callLocationFunction = insertLocationData($con, $lat, $long, $activity_time, $battery, $empId, $un, $date, $deviceToken, $activityId, '');

$con->close();

// Respond with a success message
if($callLocationFunction == 200){
    $response['status'] = '200';
    $response['message'] = 'Data inserted successfully1';
}else{
    $response['status'] = '201';
    $response['message'] = "Latlong Can't be inserted,Day end is completed";
}
echo json_encode($response);
exit;
?>
