<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 30");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/inserLocation.php';

// Read and decode input JSON
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['eid'], $data['empId'], $data['date'], $data['location']) || !is_array($data['location'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing or invalid required data: eid, empId, date, locations[]'
    ]);
    exit;
}

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];

$eid = htmlspecialchars(strip_tags($data['eid']));
$empId = htmlspecialchars(strip_tags($data['empId']));
$date = htmlspecialchars(strip_tags($data['date']));
$deviceToken = isset($data["deviceToken"]) ? htmlspecialchars(strip_tags($data["deviceToken"])) : '';

$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
if ($con->connect_error) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database connection error: ' . $con->connect_error
    ]);
    exit;
}

// Sanitize and prepare the locations
$locations = [];

foreach ($data['location'] as $loc) {
    if (isset($loc['activityLatLong'], $loc['battery'], $loc['activity_time'])) {

        list($lat, $long) = explode('#', $loc['activityLatLong']); 

        // Sanitize and store each location entry
        $locations[] = [
            'lat' => htmlspecialchars(strip_tags($lat)),
            'long' => htmlspecialchars(strip_tags($long)),
            'activity_time' => htmlspecialchars(strip_tags($loc['activity_time'])),
            'battery' => htmlspecialchars(strip_tags($loc['battery']))
        ];
    }
}

// Call the function to insert multiple locations
$result = insertMultipleBackgroundLocationData($con, $locations, $empId, $eid, $date, $deviceToken);
$con->close();

if ($result === true) {
    echo json_encode([
        'status' => '200',
        'message' => 'Data inserted successfully'
    ]);
} else {
    echo json_encode([
        'status' => '201',
        'message' => "Latlong can't be inserted, Day end is completed or failed internally"
    ]);
}
exit;
?>
