<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
// $beatPlanDetail = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Beat Planning List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);


function getPurposeNameArray($con){ 
    $queryr="SELECT * FROM `tbl_purpose_agencyvisit` WHERE deleteFlag = 0";
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array(
            'purpose_agencyVisit_id' => $datar['purpose_agencyVisit_id'],
            'purpose_agencyVisit_name' => $datar['purpose_agencyVisit_name']
        );
      }
    //   print_r($arr);
    return $arr;
}

if (!empty($data["empId"]) && !empty($data["page"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $pursoseValArry = getPurposeNameArray($con);
    $getRegionNameArray = getRegionNameArray($con);
    $empId = $data["empId"];
    $date = $data["date"];
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
   

    $sql = "SELECT  t1.*, t4.CustomerType as customerTypeName, t5.activity_name, t6.purpose_name,
                CASE
                    WHEN t1.customerType = '1' THEN t2.farmerName
                    WHEN t1.customerType = '2' THEN t3.agencyShopName
                    ELSE NULL
                END AS clientName
            FROM  
                tbl_beat_planning AS t1
            LEFT JOIN 
                tbl_farmer AS t2 ON t2.farmerId = t1.clientId AND t1.customerType = '1'
            LEFT JOIN 
                tbl_agency AS t3 ON t3.agencyId = t1.clientId AND t1.customerType = '2'
            LEFT JOIN 
                tbl_beatPlanning_customerType AS t4 ON t4.id = t1.customerType 
            LEFT JOIN 
                tbl_farmer_activity AS t5 ON t5.id = t1.farmerActivityType 
            LEFT JOIN 
                tbl_office_work_pupose AS t6 ON t6.id = t1.purposeId 
            WHERE
                t1.empId = '$empId'
            AND
                t1.date = '$date'";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t4.customerType LIKE '%$search%' 
                        OR date LIKE '%$search%' 
                   )";
    }
    
    $sql .= " ORDER BY t1.id DESC LIMIT $itemsPerPage OFFSET $offset";
    // exit;
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    // print_r($query);
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                $pursoseArray = array();
                if($row['customerType'] == '2'){
                    if($row['purposeId']){
                        $pursose = explode("#",$row['purposeId']);
                        $pursoseCount = count($pursose);
                        for($i = 0;$i < $pursoseCount;$i++){
                            if($pursose[$i]){
                                $key = '';
                                $key = array_search($pursose[$i], array_column($pursoseValArry, 'purpose_agencyVisit_id'));
                                if ($key === FALSE) {
                                    $pursoseArray[] = '';
                                } else {
                                    $pursoseArray[] = $pursoseValArry[$key]['purpose_agencyVisit_name'];
                                }
                            }
                        }
                    }else{
                        $pursoseArray = [];
                    }
                }else if($row['customerType'] == '3'){
                    $pursoseArray = array($row['purpose_name']);
                }
                
                
                if ($row['customerType'] == 1) {
                    switch ($row['farmerActivityType']) {
                        
                        case 1: // IC
                            if ($row['clientId'] == 0) {
                                $countIC = $con->query("SELECT COUNT(*) as count,activity_time FROM tbl_farmer WHERE farmerName LIKE '%".$row['newRegistration']."%' AND empId = '$empId' AND farmerName = '$date'");
                                $countICResult = $countIC->fetch_assoc();
                                $status = ($countICResult['count'] > 0) ? 1 : 0;
                                
                                $activity_time = ($countICResult['count'] > 0) ? $countICResult['activity_time'] : $row['activity_time'];
                            }
                            break;
                            
                        case 2: // SD
                            if ($row['clientId'] != 0) {
                                $countSD = $con->query("SELECT COUNT(*) as count,sd_time FROM tbl_farmactivity WHERE farmerId = '".$row['clientId']."' AND empId = '$empId' AND SD_date = '$date'");
                                $countSDResult = $countSD->fetch_assoc();
                                $status = ($countSDResult['count'] > 0) ? 1 : 0;
                                $activity_time = ($countSDResult['count'] > 0) ? $countSDResult['sd_time'] : $row['activity_time'];
                            }
                            break;
                            
                        case 3: // SDV
                            if ($row['clientId'] != 0) {
                                // echo "SELECT COUNT(*) as count,sdv_time FROM tbl_farmactivity WHERE farmerId = '".$row['clientId']."' AND empId = '$empId' AND SDV_date = '$date'";
                                $countSDV = $con->query("SELECT COUNT(*) as count,sdv_time FROM tbl_farmactivity WHERE farmerId = '".$row['clientId']."' AND empId = '$empId' AND SDV_date = '$date'");
                                $countSDVResult = $countSDV->fetch_assoc();
                                $status = ($countSDVResult['count'] > 0) ? 1 : 0;
                                $activity_time = ($countSDVResult['count'] > 0) ? $countSDVResult['sdv_time'] : $row['activity_time'];
                            }
                            break;
                            
                        case 4: // FD
                            if ($row['clientId'] != 0) {
                                $countFD = $con->query("SELECT COUNT(*) as count,activity_time FROM tbl_farmactivityFD WHERE farmerId = '".$row['clientId']."' AND empId = '$empId' AND FD_date = '$date'");
                                $countFDResult = $countFD->fetch_assoc();
                                $status = ($countFDResult['count'] > 0) ? 1 : 0;
                                $activity_time = ($countFDResult['count'] > 0) ? $countFDResult['activity_time'] : $row['activity_time'];
                            }
                            break;
        
                        case 5: // FM
                            if ($row['clientId'] != 0) {
                                $countFM = $con->query("SELECT COUNT(*) as count,activity_time FROM tbl_farmermeet WHERE farmerId = '".$row['clientId']."' AND empId = '$empId' AND FM_date = '$date'");
                                $countFMResult = $countFM->fetch_assoc();
                                $status = ($countFMResult['count'] > 0) ? 1 : 0;
                                $activity_time = ($countFMResult['count'] > 0) ? $countFMResult['activity_time'] : $row['activity_time'];
                            }
                            break;
                            
                        case 6: // Revisit
                            if ($row['clientId'] != 0) {
                                $countRevisit = $con->query("SELECT COUNT(*) as count,revisit_datetime FROM tbl_revisit WHERE farmerId = '".$row['clientId']."' AND empId = '$empId' AND revisit_date = '$date'");
                                $countRevisitResult = $countRevisit->fetch_assoc();
                                $status = ($countRevisitResult['count'] > 0) ? 1 : 0;
                                $rtime = explode('#',$countRevisitResult['revisit_datetime']);
                                $activity_time = ($countRevisitResult['count'] > 0) ? $rtime[1] : $row['activity_time'];
                            }
                            break;
                    }
                }
                //  print_r($beatPlanDetail);
                if ($row['customerType'] == 2) {
                    if ($row['farmerActivityType'] == 7) {
                        if ($row['clientId'] != 0) {
                            $countAgency = mysqli_query($con, "SELECT COUNT(*) FROM tbl_agency 
                                                WHERE agencyShopName = '".$row['newRegistration']."'
                                                AND empId = '$empId' 
                                                AND created_at = '$date'");
                            $countAgencyResult = mysqli_fetch_array($countAgency);
                            $status = ($countAgencyResult[0] > 0) ? 1 : 0;
                            $activity_time = $row['activity_time'];
                        }
                    }
                
                    if ($row['farmerActivityType'] == 8) {
                        if ($row['clientId'] != 0) {
                            $countAgencyVisit = mysqli_query($con, "SELECT COUNT(*),activity_time FROM tbl_agencyvisit 
                                                WHERE agencyId = '".$row['clientId']."' 
                                                AND empId = '$empId' 
                                                AND visitDate = '$date'");
                            $countAgencyVisitResult = mysqli_fetch_array($countAgencyVisit);
                            $status = ($countAgencyVisitResult[0] > 0) ? 1 : 0;
                            $activity_time = ($countRevisitResult['count'] > 0) ? $countRevisitResult['activity_time'] : $row['activity_time'];
                        }
                    }
                }
                
                $beatPlanDetail[] = [
                    "id" => htmlspecialchars(strip_tags($row["id"])),
                    "customerTypeId" => htmlspecialchars(strip_tags($row["customerType"])),
                    "customerType" => htmlspecialchars(strip_tags($row["customerTypeName"])),
                    "farmerActivityType" => htmlspecialchars(strip_tags($row["farmerActivityType"])),
                    "farmerActivityName" => htmlspecialchars(strip_tags($row["activity_name"])),
                    "clientId" => htmlspecialchars(strip_tags($row["clientId"])),
                    "clientName" => htmlspecialchars(strip_tags($row["clientName"])),
                    "purpose_name" => $pursoseArray,
                    "villageName" => htmlspecialchars(strip_tags($row["villageName"])),
                    "otherWork" => htmlspecialchars(strip_tags($row["otherWork"])),
                    "newRegistration" => htmlspecialchars(strip_tags($row["newRegistration"])),
                    "activity_time" => htmlspecialchars(strip_tags($row["activity_time"])),
                    "status" => $status
                ];
            
                       
            }
            
            // get unplanned IC data
            $ICArray = $con->query("SELECT * FROM tbl_farmer WHERE farmerName  empId = '$empId' AND farmerRegDate = '$date'");
            if($ICArray->num_rows > 0){
                while ($icRow = $ICArray->fetch_assoc()) {
                    $temp = [
                        "id" => '',
                        "customerTypeId" => 1,
                        "customerType" => 'Farmer Activity',
                        "farmerActivityType" => 1,
                        "farmerActivityName" => 'IC',
                        "clientId" => $icRow['farmerId'],
                        "clientName" => $icRow['farmerName'],
                        "purpose_name" => '',
                        "villageName" => '',
                        "otherWork" => '',
                        "newRegistration" => $icRow['farmerName'],
                        "activity_time" => $icRow['activity_time'],
                        "status" => 2 //unplanned
                    ];
                    $beatPlanDetail[] = $temp;
                    
                }
            }
            
            //get unplanned SD data
            // echo "SELECT t1.*, t2.farmerName FROM tbl_farmactivity as t1 JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId WHERE  t1.empId = '$empId' AND t1.SD_date = '$date'";
            $SDArray = $con->query("SELECT t1.*, t2.farmerName FROM tbl_farmactivity as t1 JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId WHERE  t1.empId = '$empId' AND t1.SD_date = '$date'");
            if($SDArray->num_rows > 0){
                while ($sdRow = $SDArray->fetch_assoc()) {
                    $temp = [
                        "id" => '',
                        "customerTypeId" => 1,
                        "customerType" => 'Farmer Activity',
                        "farmerActivityType" => 2,
                        "farmerActivity" => 'SD',
                        "clientId" => $sdRow['farmerId'],
                        "clientName" => $sdRow['farmerName'],
                        "purpose_name" => '',
                        "villageName" => '',
                        "otherWork" => '',
                        "newRegistration" => '',
                        "activity_time" => $sdRow['activity_time'],
                        "status" => 2 // unplanned
                    ];
                    $beatPlanDetail[] = $temp;
                }
            }
            
            //get unplanned SDV data
            $SDVArray = $con->query("SELECT t1.*, t2.farmerName FROM tbl_farmactivity as t1 JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId WHERE  t1.empId = '$empId' AND t1.SDV_date = '$date'");
            if($SDVArray->num_rows > 0){
                while ($sdvRow = $SDVArray->fetch_assoc()) {
                    $temp = [
                        "id" => '',
                        "customerTypeId" => 1,
                        "customerType" => 'Farmer Activity',
                        "farmerActivityType" => $row['farmerActivityType'],
                        "farmerActivityName" => 3,
                        "clientId" => $sdvRow['farmerId'],
                        "clientName" => $sdvRow['farmerName'],
                        "purpose_name" => '',
                        "villageName" => '',
                        "otherWork" => '',
                        "newRegistration" => '',
                        "activity_time" => $sdvRow['activity_time'],
                        "status" => 2
                    ];
                    $beatPlanDetail[] = $temp;
                }
            }
            
            // get unplanned FD data
            $FDArray = $con->query("SELECT t1.*, t2.farmerName FROM tbl_farmactivityFD as t1 JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId WHERE  t1.empId = '$empId' AND t1.FD_date = '$date'");
            if($FDArray->num_rows > 0){
                while ($fdRow = $FDArray->fetch_assoc()) {
                    $temp = [
                        "id" => '',
                        "customerTypeId" => 1,
                        "customerType" => 'Farmer Activity',
                        "farmerActivityType" => 4,
                        "farmerActivityName" => 'FD',
                        "clientId" => $fdRow['farmerId'],
                        "clientName" => $fdRow['farmerName'],
                        "purpose_name" => '',
                        "villageName" => '',
                        "otherWork" => '',
                        "newRegistration" => '',
                        "activity_time" => $fdRow['activity_time'],
                        "status" => 2 //unplanned
                    ];
                    $beatPlanDetail[] = $temp;
                }
            }
            
            //get unplanned FM data
            $FMArray = $con->query("SELECT t1.*, t2.farmerName FROM tbl_farmermeet as t1 JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId WHERE  t1.empId = '$empId' AND t1.FM_date = '$date'");
            if($FMArray->num_rows > 0){
                while ($fmRow = $FMArray->fetch_assoc()) {
                    $temp = [
                        "id" => '',
                        "customerTypeId" => 1,
                        "customerType" => 'Farmer Activity',
                        "farmerActivityType" => $row['farmerActivityType'],
                        "farmerActivityName" => 5,
                        "clientId" => 0,
                        "clientName" => '',
                        "purpose_name" => '',
                        "villageName" => $row['villageNameID'],
                        "otherWork" => '',
                        "newRegistration" => '',
                        "activity_time" => $fmRow['activity_time'],
                        "status" => 2 //unplanned
                    ];
                    $beatPlanDetail[] = $temp;
                }
            }
            
            //get unplanned revisit
            $revisitArray = $con->query("SELECT t1.*, t2.farmerName FROM tbl_revisit as t1 JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId WHERE  t1.empId = '$empId' AND t1.revisit_date = '$date'");
            if($revisitArray->num_rows > 0){
                while ($revisitRow = $revisitArray->fetch_assoc()) {
                    $temp = [
                        "id" => '',
                        "customerTypeId" => 1,
                        "customerType" => 'Farmer Activity',
                        "farmerActivityType" => $row['farmerActivityType'],
                        "farmerActivityName" => 6,
                        "clientId" => $revisitRow['farmerId'],
                        "clientName" => $revisitRow['farmerName'],
                        "purpose_name" => '',
                        "villageName" => '',
                        "otherWork" => '',
                        "newRegistration" => '',
                        "activity_time" => $revisitRow['activity_time'],
                        "status" => 2 //unplanned
                    ];
                    $beatPlanDetail[] = $temp;
                }
            }
            
            //get unplanned new agency
            $AgencyQuery = "SELECT * FROM tbl_agency 
                                    WHERE empId = '$empId' 
                                    AND created_at = '$date'";
            $AgencyResult = mysqli_query($con, $AgencyQuery);
    
            while ($AgencyRow = mysqli_fetch_array($AgencyResult)) {
                $beatPlanDetail[] = [
                    "id" => '',
                    "customerTypeId" => 2,
                    "customerType" => 'Agency Activity',
                    "farmerActivityType" => 7,
                    "farmerActivityName" => 'New Agency',
                    "clientId" => $AgencyRow['agencyId'],
                    "clientName" => $AgencyRow['agencyShopName'],
                    "purpose_name" => '',
                    "villageName" => '',
                    "otherWork" => '',
                    "newRegistration" => $AgencyRow['agencyShopName'],
                    "activity_time" => $AgencyRow['activity_time'],
                    "status" => ''
                ];
            }
            
            //get unplanned agency visit
            $AgencyVisitQuery = "SELECT t1.*, t2.agencyShopName 
                                FROM tbl_agencyvisit as t1 
                                LEFT JOIN tbl_agency as t2 ON t1.agencyId = t2.agencyId 
                                WHERE t1.empId = '$empId' 
                                AND visitDate = '$date'";
            $AgencyVisitResult = mysqli_query($con, $AgencyVisitQuery);
            while ($AgencyVisitRow = mysqli_fetch_array($AgencyVisitResult)) {
                $beatPlanDetail[] = [
                    "id" => '',
                    "customerTypeId" => 2,
                    "customerType" => 'Agency Activity',
                    "farmerActivityType" => 8,
                    "farmerActivityName" => 'Agency Visit',
                    "clientId" => $AgencyVisitRow['agencyId'],
                    "clientName" => $AgencyVisitRow['agencyShopName'],
                    "purpose_name" => '',
                    "villageName" => '',
                    "otherWork" => '',
                    "newRegistration" => '',
                    "activity_time" => $AgencyVisitRow['activity_time'],
                    "status" => 2
                ];
            }
            
            // Initialize an array to store unique entries
            $uniqueEntries = [];
            $entries = $beatPlanDetail;
            // Iterate through the entries array
            foreach ($entries as $entry) {
                // Create a unique key based on desired fields
                $key = $entry['customerTypeId'] . '_' . $entry['farmerActivityType'] . '_' . $entry['clientId'] . '_' . implode('_', $entry['purpose_name']) . '_' . $entry['villageName'] . '_' . $entry['newRegistration'] . '_' . $entry['activity_time'];
            
                // Check if the key already exists in uniqueEntries
                if (!isset($uniqueEntries[$key])) {
                    // Add the entry to uniqueEntries
                    $uniqueEntries[$key] = $entry;
                } else {
                    // Entry with the same key exists, check status and remove if status = 2
                    if ($entry['status'] != 2) {
                        // Replace the existing entry with the new one if status is not 2
                        $uniqueEntries[$key] = $entry;
                    }
                }
            }
            
            // Convert the uniqueEntries array back to a sequential indexed array
            $uniqueEntries = array_values($uniqueEntries);
            
            // Output the unique array
            // print_r($uniqueEntries);
            
            // Define a custom sorting function
            function sortByActivityTime($a, $b) {
                return strtotime($a['activity_time']) - strtotime($b['activity_time']);
            }
            
            // Sort the array using the custom sorting function
            usort($uniqueEntries, 'sortByActivityTime');

            // print_r($beatPlanDetail);
            $response['beatPlanningList'] = $uniqueEntries;
            $response['rowCount'] = count($beatPlanDetail);
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
            $response['beatPlanningList'] = $beatPlanDetail;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
