<?php
error_reporting(0); // Change to E_ALL during testing
header("Access-Control-Allow-Origin: *");

require_once '../db_config/config1.php';
require_once '../db_config/configmulti.php';
require_once 'functions/calculateAttendanceFlag.php';

try {
    $response = [];

    if (!isset($_POST["username"])) {
        $response["error"] = true;
        $response["MESSAGE"] = "username missing";
        $response["STATUS"] = 400;
        echo json_encode($response);
        exit;
    }

    $username = $_POST['username'];
    $db_prefix = explode("-", $username)[0];

    // Fetch client DB from superadmin
    $clientQuery = $con_admin->prepare("SELECT status, exp_date FROM tbl_clients WHERE dbname = ?");
    $clientQuery->bind_param("s", $db_prefix);
    $clientQuery->execute();
    $clientResult = $clientQuery->get_result();
    $clientData = $clientResult->fetch_assoc();

    if (!$clientData || $clientData['status'] === 'Deactive' || $clientData['exp_date'] < date('Y-m-d')) {
        $response["error"] = true;
        $response["MESSAGE"] = "Client Deactivated or Expired";
        $response["STATUS"] = 400;
        echo json_encode($response);
        exit;
    }

    // Validate required POST fields
    $requiredFields = ['id', 'stime', 'lat', 'long', 'start_image'];
    foreach ($requiredFields as $field) {
        if (empty($_POST[$field])) {
            $response["error"] = true;
            $response["MESSAGE"] = "Missing parameter: $field";
            $response["STATUS"] = 400;
            echo json_encode($response);
            exit;
        }
    }

    // Connect to client DB
    $clientDbName = $base_dbname . $db_prefix;
    $mysql = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $clientDbName);
    if ($mysql->connect_error) {
        $response["error"] = true;
        $response["MESSAGE"] = "Database connection failed: " . $mysql->connect_error;
        echo json_encode($response);
        exit;
    }

    // Input sanitation
    $id = (int)$_POST['id'];
    $stime = $_POST['stime'];
    $sdis = (float) ($_POST['sdis'] ?? 0);
    $lat = $_POST['lat'];
    $long = $_POST['long'];
    $start_image = $_POST['start_image'];
    $token = $_POST['token'] ?? '';
    $appVersion = $_POST['versionName'] ?? '';
    $login_type = $_POST['login_type'] ?? 1;
    $batt = $_POST['bat'] ?? "0";
    $date = date('Y-m-d');
    $start_gps = "$lat,$long";
    $lastLatLong = "$lat/$long";
    $lltb = "$lat/$long/$stime/$batt";

    // Check if employee is active
    $empCheck = $mysql->prepare("SELECT id, region, shift FROM tbl_employee WHERE id = ? AND deleteFlag = 0");
    $empCheck->bind_param("i", $id);
    $empCheck->execute();
    $empResult = $empCheck->get_result();

    if ($empResult->num_rows === 0) {
        $response["error"] = true;
        $response["MESSAGE"] = "Employee is deactivated";
        $response["STATUS"] = 400;
        echo json_encode($response);
        exit;
    }
    $empData = $empResult->fetch_assoc();
    $region = $empData['region'];
     $shift_id = $empData['shift'];

    // Check if employee is on leave today
    $leaveCheck = $mysql->prepare("SELECT leave_id FROM tbl_leave_application_details WHERE emp_id = ? AND leave_date = ?");
    $leaveCheck->bind_param("is", $id, $date);
    $leaveCheck->execute();
    $leaveResult = $leaveCheck->get_result();
    if ($leaveResult->num_rows > 0) {
        $leave_id = $leaveResult->fetch_object()->leave_id;

        // Adjust or delete leave
        $leaveQuery = "SELECT leave_from, leave_upto, total_days FROM tbl_leave_application WHERE leave_id = '$leave_id'";
        $leaveRes = $mysql->query($leaveQuery);
        if ($leaveRes && $leaveRes->num_rows > 0) {
            $leaveData = $leaveRes->fetch_assoc();
            if ($leaveData['total_days'] == 1) {
                $mysql->query("DELETE FROM tbl_leave_application WHERE leave_id = '$leave_id'");
                $mysql->query("DELETE FROM tbl_leave_application_details WHERE leave_id = '$leave_id' AND leave_date = '$date'");
            } else {
                if ($date == $leaveData['leave_from']) {
                    $mysql->query("DELETE FROM tbl_leave_application WHERE leave_id = '$leave_id'");
                    $mysql->query("DELETE FROM tbl_leave_application_details WHERE leave_id = '$leave_id' AND leave_date >= '$date'");
                } elseif ($date > $leaveData['leave_from'] && $date <= $leaveData['leave_upto']) {
                    $new_leave_upto = date('Y-m-d', strtotime($date . ' -1 day'));
                    $interval = (new DateTime($leaveData['leave_from']))->diff(new DateTime($new_leave_upto));
                    $new_total_days = $interval->days + 1;
                    $mysql->query("UPDATE tbl_leave_application SET leave_upto = '$new_leave_upto', total_days = '$new_total_days' WHERE leave_id = '$leave_id'");
                    $mysql->query("DELETE FROM tbl_leave_application_details WHERE leave_id = '$leave_id' AND leave_date >= '$date'");
                }
            }
        }
    }



    // Prevent duplicate stime/sdis record
    $dupCheck = $mysql->prepare("SELECT 1 FROM tbl_daystart WHERE uid = ? AND sdis = ? AND stime = ?");
    $dupCheck->bind_param("ids", $id, $sdis, $stime);
    $dupCheck->execute();
    $dupResult = $dupCheck->get_result();
    if ($dupResult->num_rows > 0) {
        $response["error"] = true;
        $response["MESSAGE"] = "Similar data already exists.";
        $response["STATUS"] = 400;
        echo json_encode($response);
        exit;
    }

    // Check if already started today
    $alreadyStarted = $mysql->prepare("SELECT stime FROM tbl_daystart WHERE uid = ? AND date = ?");
    $alreadyStarted->bind_param("is", $id, $date);
    $alreadyStarted->execute();
    $startRes = $alreadyStarted->get_result();
    if ($startRes->num_rows > 0 && $startRes->fetch_assoc()['stime']) {
        $response["error"] = true;
        $response["MESSAGE"] = "Already started";
        $response["STATUS"] = 400;
        echo json_encode($response);
        exit;
    }

    // === Determine delayFlag using shift
    $delayFlag = 0;
    if ($shift_id > 0) {
        $shiftQuery = "SELECT late_mark_start, late_mark_end, half_day_time, early_mark_start, early_mark_end, login_end, work_hour 
                       FROM tbl_emp_shift 
                       WHERE id = '$shift_id' AND is_active = 1 AND deleteFlag = 0 LIMIT 1";
        $shiftResult = $mysql->query($shiftQuery);
        if ($shiftResult && $shiftResult->num_rows > 0) {
            $shift = $shiftResult->fetch_assoc();
            $delayFlag = calculateAttendanceFlag($stime, NULL, $shift); // etime not known yet

            if (in_array($delayFlag, [1, 3, 5])) {
                $query = "INSERT INTO tbl_late_login (empId, date, time) 
                                   VALUES ('$id', '$date', '$stime')";
                $mysql->query($query);
            }
        }
    }
    
    // Insert daystart
    $zeroTime = "00:00:00";
    $insertDaystart = $mysql->prepare("INSERT INTO tbl_daystart 
        (uid, login_type, device_token, date, stime, sdis, start_image, sgps, delayFlag, total_hours, status, created_at) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, NOW())");
    $insertDaystart->bind_param("iisssdssss", $id, $login_type, $token, $date, $stime, $sdis, $start_image, $start_gps, $delayFlag, $zeroTime);
    $successStart = $insertDaystart->execute();
    
    
    // Insert into tbl_track
    $activityLatLong = str_replace("#", "/", $lastLatLong);
    $activityGeotagVal = $activityLatLong . '/' . $stime . '/0/0';
    // $insertTrack = $mysql->prepare("INSERT INTO tbl_track 
    //     (login_type,eid, device_token, lltb, date, lastLatLong, activityGeotag) 
    //     VALUES (?,?, ?, ?, ?, ?, ?)");
    // $insertTrack->bind_param("iisssss", 1,$username, $token, $lltb, $date, $lastLatLong, $activityGeotagVal);
    
    $loginType = 1; // or derive it dynamically
    $insertTrack = $mysql->prepare("INSERT INTO tbl_track 
        (login_type, eid, device_token, lltb, date, lastLatLong, activityGeotag) 
        VALUES (?, ?, ?, ?, ?, ?, ?)");
    
    $insertTrack->bind_param("issssss", $loginType, $username, $token, $lltb, $date, $lastLatLong, $activityGeotagVal);

    
    // GPS Log
    $insertGPS = $mysql->prepare("INSERT INTO tbl_gps_log_status (date, empId, gps_status, gps_time) VALUES (?, ?, '1', ?)");
    $insertGPS->bind_param("sis", $date, $id, $stime);

    // Update appVersion/token
    $updateEmp = $mysql->prepare("UPDATE tbl_employee SET appVersion = ?, token = ? WHERE id = ?");
    $updateEmp->bind_param("ssi", $appVersion, $token, $id);

    // Insert activity count
    $insertActivity = $mysql->prepare("INSERT INTO tbl_activity_count_current_year 
        (empId, regionId, activityDate, daystart_time, lateLogin) 
        VALUES (?, ?, ?, ?, ?)");
    $insertActivity->bind_param("iissi", $id, $region, $date, $stime, $delayFlag);

    // Execute all
    if ($successStart && $insertTrack->execute() && $insertGPS->execute() && $updateEmp->execute() && $insertActivity->execute()) {
        $response["error"] = false;
        $response["MESSAGE"] = "Successful insert data";
        $response["aws-folder"] = $db_prefix;
        $response["STATUS"] = 200;
    } else {
        $response["error"] = true;
        $response["MESSAGE"] = "Insertion failed";
        $response["STATUS"] = 500;
    }

    echo json_encode($response);
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
