<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$farmerProfileArray = [];
$farmerProfileDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Beat Planning List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);
$beatPlanningArray = array();

function getPurposeNameArray($con){ 
    $queryr="SELECT * FROM `tbl_purpose_agencyvisit` WHERE deleteFlag = 0";
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array(
            'purpose_agencyVisit_id' => $datar['purpose_agencyVisit_id'],
            'purpose_agencyVisit_name' => $datar['purpose_agencyVisit_name']
        );
      }
    //   print($arr);
    return $arr;
}

if (!empty($data["empId"]) && !empty($data["date"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $pursoseValArry = getPurposeNameArray($con);
    $getRegionNameArray = getRegionNameArray($con);
    $empId = $data["empId"];
    $date = $data["date"];
    
    $sqlDayStart = "SELECT * FROM tbl_daystart WHERE uid = '$empId' AND date = '$date'";
    $resultDayStart = mysqli_query($con,$sqlDayStart);
    $rowDayStart = mysqli_fetch_assoc($resultDayStart);
    $status = $rowDayStart['status'];
    
    $sql = "SELECT  t1.*, t4.CustomerType as customerTypeName, t5.activity_name, t6.purpose_name,
                CASE
                    WHEN t1.customerType = '1' THEN t2.farmerName
                    WHEN t1.customerType = '2' THEN t3.agencyShopName
                    ELSE NULL
                END AS clientName
            FROM  
                tbl_beat_planning AS t1
            LEFT JOIN 
                tbl_farmer AS t2 ON t2.farmerId = t1.clientId AND t1.customerType = '1'
            LEFT JOIN 
                tbl_agency AS t3 ON t3.agencyId = t1.clientId AND t1.customerType = '2'
            LEFT JOIN 
                tbl_beatPlanning_customerType AS t4 ON t4.id = t1.customerType 
            LEFT JOIN 
                tbl_farmer_activity AS t5 ON t5.id = t1.farmerActivityType 
            LEFT JOIN 
                tbl_office_work_pupose AS t6 ON t6.id = t1.purposeId 
            WHERE
                t1.empId = '$empId'
            AND
                t1.date = '$date'";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t4.customerType LIKE '%$search%' 
                        OR date LIKE '%$search%' 
                   )";
    }
    
    $sql .= " ORDER BY t1.id DESC ";
    // exit;
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                $pursoseArray = array();
                $activity_time = $row['activity_time'];
                $agencyType = '';
                $agencyLatLong = '';
                if($row['customerType'] == '2'){
                    $pursose = explode("#",$row['purposeId']);
                    $pursoseCount = count($pursose);
                    for($i = 0;$i < $pursoseCount;$i++){
                        if($pursose[$i]){
                            $key = '';
                            $key = array_search($pursose[$i], array_column($pursoseValArry, 'purpose_agencyVisit_id'));
                            if ($key === FALSE) {
                                $pursoseArray[] = '';
                            } else {
                                $pursoseArray[] = $pursoseValArry[$key]['purpose_agencyVisit_name'];
                            }
                        }
                    }
                    if($row['farmerActivityType'] == '8'){
                        if($row['performedStatus'] == '1'){
                            $activity_time = $row['performedTime'];
                        }
                    }
                    $clientId = $row['clientId'];
                    $sql1 = "SELECT agencyType,latlong FROM tbl_agency WHERE agencyId = '$clientId'";
                    $result1 = mysqli_query($con,$sql1);
                    $row1 = mysqli_fetch_assoc($result1);
                    $agencyType = $row1['agencyType'];
                    $agencyLatLong = $row1['latlong'];
                }else if($row['customerType'] == '3'){
                    $pursoseArray = array($row['purpose_name']);
                    $agencyType = '';
                    $agencyLatLong = '';
                }
                
                array_push(
                    $beatPlanningArray,
                    array(
                        "id" => htmlspecialchars(strip_tags($row["id"])),
                        "customerTypeId" => htmlspecialchars(strip_tags($row["customerType"])),
                        "customerType" => htmlspecialchars(strip_tags($row["customerTypeName"])),
                        "farmerActivityType" => htmlspecialchars(strip_tags($row["farmerActivityType"])),
                        "farmerActivityName" => htmlspecialchars(strip_tags($row["activity_name"])),
                        "clientId" => htmlspecialchars(strip_tags($row["clientId"])),
                        "clientName" => htmlspecialchars(strip_tags($row["clientName"])),
                        "agencyType" => $agencyType,
                        "agencyLatLong" => $agencyLatLong,
                        "purpose_name" => $pursoseArray,
                        "villageName" => htmlspecialchars(strip_tags($row["villageName"])),
                        "otherWork" => htmlspecialchars(strip_tags($row["otherWork"])),
                        "newRegistration" => htmlspecialchars(strip_tags($row["newRegistration"])),
                        // "latlong" => htmlspecialchars(strip_tags($row["latlong"])),
                        "performedStatus" => htmlspecialchars(strip_tags($row["performedStatus"])),
                        "from_time" => htmlspecialchars(strip_tags($row["from_time"])),
                        "to_time" => htmlspecialchars(strip_tags($row["to_time"])),
                        "date" => htmlspecialchars(strip_tags($row["date"])),
                        "activity_time" => $activity_time,
                        "dayStartStatus" => $status
                    )
                );
                       
            }
            // print_r($beatPlanningArray);
            // Define a custom sorting function
            function sortByActivityTime($a, $b) {
                return strtotime($a['activity_time']) - strtotime($b['activity_time']);
            }
            
            // Sort the array using the custom sorting function
            usort($beatPlanningArray, 'sortByActivityTime');

            $response['beatPlanningList'] = $beatPlanningArray;
            $response['rowCount'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
            $response['beatPlanningList'] = $farmerProfileArray;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
