<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = [];
$empRouteList = [];
$activityCountList = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$FailStatusCode = 202; 
$FailStatusMsg = "Credentials Incorrect!";

$data = json_decode(file_get_contents("php://input"), true);

$date = $data['date'];
$empId = $data['empId'];
$un = $data['eid'];
$un1 = explode("-", $un); 
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

$sql = "SELECT * FROM `tbl_track` t1 WHERE t1.eid = '$un' AND t1.`date` = '$date' ";
$query = mysqli_query($con, $sql);
$empRouteCount = mysqli_num_rows($query);

while ($row = mysqli_fetch_array($query)) {
    
    $sql1 = "SELECT * FROM `tbl_daystart` t1 WHERE t1.uid = '$empId' AND t1.`date` = '$date' ";
    $query1 = mysqli_query($con, $sql1);
    $daystartData = mysqli_fetch_assoc($query1);
    $activityGeotagForMarkerPosition = ($row['activityGeotag']) ? explode('#', $row['activityGeotag']) : [];
    // Assuming $conn is your mysqli connection object
    $activity_name = [];
   
    foreach ($activityGeotagForMarkerPosition as $position) {
        $indVal = explode('/', $position);
        $activityName = '';
        $villageName = '';
        $purpose = '';
        $activityId = $indVal[4];
        $activityType = $indVal[3];
        switch ($activityType) {
            case 1:
                $sqlActivit = "SELECT farmerName,farmerCity FROM tbl_farmer WHERE farmerId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['farmerName'];
                $purpose = 'IC';
                $villageName = $rowActivity['farmerCity'];
                break;
            case 2:
                $sqlActivit = "SELECT t2.farmerName,farmerCity FROM tbl_farmactivity AS t1 LEFT JOIN tbl_farmer AS t2 ON t1.farmerId = t2.farmerId WHERE faId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['farmerName'];
                $purpose = 'SD';
                $villageName = $rowActivity['farmerCity'];
                break;
            case 3:
                $sqlActivit = "SELECT t2.farmerName,farmerCity FROM tbl_farmactivity AS t1 LEFT JOIN tbl_farmer AS t2 ON t1.farmerId = t2.farmerId WHERE faId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['farmerName'];
                $purpose = 'SDV';
                $villageName = $rowActivity['farmerCity'];
                break;
            case 4:
                $sqlActivit = "SELECT t2.farmerName,farmerCity FROM tbl_farmactivityFD AS t1 LEFT JOIN tbl_farmer AS t2 ON t1.farmerId = t2.farmerId WHERE fafdId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['farmerName'];
                $purpose = 'FD';
                $villageName = $rowActivity['farmerCity'];
                break;
            case 5:
                $sqlActivit = "SELECT villageNameID FROM tbl_farmermeeting WHERE fmId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['villageNameID'];
                $purpose = 'FM';
                $villageName = '';
                break;
            case 6:
                $sqlActivit = "SELECT agencyShopName,agencyCity FROM tbl_agencyvisit AS t1 LEFT JOIN tbl_agency AS t2 ON t1.agencyId = t2.agencyId WHERE visitId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                // print_r()
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['agencyShopName'];
                $purpose = 'AV';
                $villageName = $rowActivity['agencyCity'];
                break;
            case 7:
                $sqlActivit = "SELECT agencyShopName,agencyCity FROM tbl_agency WHERE agencyId = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['agencyShopName'];
                $purpose = 'New Agency';
                $villageName = $rowActivity['agencyCity'];
                break;
            case 8:
                $sqlActivit = "SELECT agencyShopName,agencyCity FROM tbl_ordernew AS t1 LEFT JOIN tbl_agency AS t2 ON t1.did = t2.agencyId WHERE oid = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['agencyShopName'];
                $villageName = $rowActivity['agencyCity'];
                $purpose = 'Order';
                break;
            case 9:
                $sqlActivit = "SELECT agencyShopName,agencyCity FROM tbl_payment AS t1 LEFT JOIN tbl_agency AS t2 ON t1.dealerName = t2.agencyId WHERE id = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['agencyShopName'];
                $purpose = 'Payment';
                $villageName = $rowActivity['agencyCity'];
                break;
            case 12:
                $sqlActivit = "SELECT farmerName,farmerCity FROM tbl_revisit AS t1 LEFT JOIN tbl_farmer AS t2 ON t1.farmerId = t2.farmerId WHERE rid = '$activityId'";
                $resultActivity = mysqli_query($con,$sqlActivit);
                $rowActivity = mysqli_fetch_assoc($resultActivity);
                $activityName = $rowActivity['farmerName'];
                $villageName = $rowActivity['farmerCity'];
                $purpose = 'Revisit';
                break;
            default:
                // Handle default case
                break;
        }

        $object = [
            'agencyType' => $indVal[3],
            'Purpose' => $purpose,
            'activity_name' => $activityName,
            'villageName' => $villageName,
            'lat' => floatval($indVal[0]),
            'long' => floatval($indVal[1]),
            'activity_time' => $indVal[2]
        ];
    
        array_push($activity_name, $object);

    }

// Use $activity_name array as needed

    $empRouteList[] = [
        "eid" => $row['eid'],
        "daystart" => $daystartData['stime'],
        "dayend" => $daystartData['etime'],
        "distance_travel" => number_format($daystartData['disgps'],3),
        "lltb" => $row['lltb'],
        "lastLatLong" => $row['lastLatLong'],
        "activityGeotag" => $row['activityGeotag'],
        "activityLocationDetails" => $activity_name
    ];
}

$sql = "SELECT * FROM `tbl_activity_count_current_year` WHERE empId = '$empId' AND `activityDate` = '$date' ";
$query = mysqli_query($con, $sql);

while ($row = mysqli_fetch_array($query)) {
    $activityCountList[] = [
        "ic" => $row['ic'],
        "sd" => $row['sd'],
        "sdv" => $row['sdv'],
        "fd" => $row['fd'],
        "fm" => $row['fm'],
        "av" => $row['av'],
        "revisit" => $row['revisit']
    ];
}

$visitListArray = [];   
$sqlAv = "SELECT *,
            (SELECT category_name FROM tbl_category WHERE category_id = t1.agencyRegion) as regionName,
            (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName 
          FROM `tbl_agencyvisit` t1 
          LEFT JOIN `tbl_agency` t2 
          ON 
          t1.agencyId = t2.agencyId 
          LEFT JOIN tbl_purpose_agencyvisit t3
          ON t1.purpose = t3.purpose_agencyVisit_id
          WHERE 
          t1.empId = '$empId' 
          AND 
          t1.visitDate = '$date'";
$queryAv = mysqli_query($con, $sqlAv);
$rowCountAv = mysqli_num_rows($queryAv);

while ($row = mysqli_fetch_array($queryAv)) {
    $minutes = $row["totalTimeSpent"];
    $timeSpent = floor($minutes / 60).' hrs '.($minutes -   floor($minutes / 60) * 60);
    
    array_push($visitListArray, [
        "rowid" => htmlspecialchars($row["visitId"]),
        "dealerName" => htmlspecialchars($row["agencyShopName"]),
        // "timespan" => htmlspecialchars($row["timespan"]),
        "hrTime" => htmlspecialchars($row["hrTime"]),
        "mTime" => $timeSpent,
        "totalTimeSpent" => $timeSpent,
        "purpose" => htmlspecialchars($row["purpose_agencyVisit_name"]),
        "date" => htmlspecialchars($row["visitDate"]),
        "remark" => htmlspecialchars($row["remark"]),
        "empName" => htmlspecialchars($row["empName"])
    ]);
        
}

$response['status'] = $SuccessStatusCode;
$response['message'] = $SuccessStatusMsg;
$response['empRouteList'] = $empRouteList;
$response['activityCountList'] = $activityCountList;
$response['agencyVisitList'] = $visitListArray;

echo json_encode($response);
?>
