<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include("functions/getIds.php");

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access terminated!";
$data = json_decode(file_get_contents("php://input"), true);

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

$response = [];
$FDarray = [];

if (!empty($data["empId"])) {
    $empid = $data["empId"];
    $date = $data["date"];
    
    $itemsPerPage = 10; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    

    $sql = "SELECT *, 
            (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName  
            FROM 
            `tbl_farmactivityFD` t1
            LEFT JOIN `tbl_farmer` t2
            ON 
            t1.`farmerId` = t2.farmerId 
            LEFT JOIN `tbl_crop` t3
            ON 
            t3.`cropId` = t1.`cropId` 
            LEFT JOIN `tbl_activity_product` t4
            ON 
            t4.`pid` = t1.`productId` 
            WHERE 
            t1.`empId` = '$empid' 
            AND 
            t1.FD_date = '$date'";
            
    $search = isset($data['search']) ? $data['search'] : '';

    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t2.farmerName LIKE '%$search%' 
                  OR t2.farmerMobile LIKE '%$search%' 
                  OR t2.farmerAddress LIKE '%$search%' 
                  OR t2.farmerCity LIKE '%$search%' 
                  OR t1.FD_date LIKE '%$search%' )";
    }
    
    $sql .= "ORDER BY fafdId DESC LIMIT $itemsPerPage OFFSET $offset";
    
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                array_push($FDarray, [
                    "FDId" => $row["fafdId"],
                    "farmerId" => $row["farmerId"],
                    "farmerFD" => $row["farmerFD"],
                    "crop" => $row["cropName"],
                    "product" => $row["productName"],
                    "FD_date" => $row["FD_date"],
                    "farmerName" => $row["farmerName"],
                    "farmerMobile" => $row["farmerMobile"],
                    "farmerLocation" => $row["farmerLocation"],
                    "farmerAddress" => $row["farmerAddress"],
                    "farmerCity" => $row["farmerCity"],
                    "approvstatus" => $row["approvstatus"],
                    "FD_Req_Date" => $row["FD_Req_Date"],
                    "FD_Flag" => $row["FD_Flag"],
                    "farmerRegion" => $row["farmerRegion"]
                ]);
                        
            }
            $response['FDlist'] = $FDarray;

        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;   
        }
        $response['Count'] = $actualDataCounter;
        $response['error'] = false;
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
    } else {
        $response['error'] = true;
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
?>
