<?php
error_reporting(0);
include("functions/getIds.php");

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";
$unauthorisedUserCode = 203;
$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access terminated!";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$FMarray = [];
$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if (!empty($data["empId"]) && !empty($data["page"])) {
    $empid = $data["empId"];
    $fmType = $data["fmType"];
    $date = $data["date"];
    
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    
    if($fmType == 1){
        $sql = "SELECT *, (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName ,
            (SELECT category_name FROM tbl_category WHERE category_id = t1.farmerRegion) as category_name,
            (SELECT agencyShopName FROM tbl_agency WHERE agencyId = t1.fmdealernameid) as agencyShopName
            FROM `tbl_farmermeeting` t1 
            WHERE `empId` = '$empid' AND `fmDate` = '$date' AND fmType IN (1,3)";
    }else if($fmType == 2){
        $sql = "SELECT *, (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName ,
            (SELECT category_name FROM tbl_category WHERE category_id = t1.farmerRegion) as category_name,
            (SELECT agencyShopName FROM tbl_agency WHERE agencyId = t1.fmdealernameid) as agencyShopName
            FROM `tbl_farmermeeting` t1 
            WHERE `empId` = '$empid' AND `fmDate` = '$date' AND fmType IN (2,4)";
    }else{
        $sql = "SELECT *, (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName ,
            (SELECT category_name FROM tbl_category WHERE category_id = t1.farmerRegion) as category_name ,
            (SELECT agencyShopName FROM tbl_agency WHERE agencyId = t1.fmdealernameid) as agencyShopName
            FROM `tbl_farmermeeting` t1 
            WHERE `empId` = '$empid' AND `fmDate` = '$date'";
    }
    
    $search = isset($data['search']) ? $data['search'] : '';

    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t1.villageNameID LIKE '%$search%' 
                  OR t1.FMReqDate LIKE '%$search%' 
                  OR (SELECT agencyShopName FROM tbl_agency WHERE agencyId = t1.fmdealernameid) LIKE '%$search%' 
                  OR t1.fmDate LIKE '%$search%' )";
    }
    
    $sql .= "ORDER BY fmId DESC LIMIT $itemsPerPage OFFSET $offset";
    
    // echo $sql;
    
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                array_push($FMarray, [
                    "fmId" => $row["fmId"],
                    "empName" => $row["empName"],
                    "farmerId" => $row["farmerId"],
                    "fmType" => $row["fmType"],
                    "fmCropIds" => $row["fmCropIds"],
                    "fmProductIds" => $row["fmProductIds"],
                    "fmNos" => $row["fmNos"],
                    "Actual_Farmerno" => $row["Actual_Farmerno"],
                    "fmRemark" => $row["fmRemark"],
                    "fmDate" => $row["fmDate"],
                    "FMReqDate" => $row["FMReqDate"],
                    "fmPhoto" => $row["fmPhoto"],
                    "empId" => $row["empId"],
                    "accompainedBy" => $row["accompanied"],
                    "fmdealernameid" => $row["fmdealernameid"],
                    "agencyShopName" => $row["agencyShopName"],
                    "villageName" => $row["villageNameID"],
                    "approvstatus" => $row["approvstatus"],
                    "Aprove_Date" => $row["Aprove_Date"],
                    "Aprove_By" => $row["Aprove_By"],
                    "auth_remark" => $row["auth_remark"],
                    "fmLatLong" => $row["latlong"],
                    "farmerRegion" => $row["category_name"]
                ]);
                    
            }
            
            $response['FMList'] = $FMarray;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
    
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
?>
