<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include("functions/getIds.php");

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorised access terminated!";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$icarray = [];

if (!empty($data["empId"])) {
    $un = $data['eid'];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

    $empid = $data["empId"];
    $date = $data["date"];
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    
    $sql = "SELECT *, (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName
            FROM `tbl_farmer` t1
            WHERE `empId` = '$empid' AND `farmerRegDate` = '$date'";
            
    $search = isset($data['search']) ? $data['search'] : '';

    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( farmerName LIKE '%$search%' 
                  OR farmerMobile LIKE '%$search%' 
                  OR farmerAddress LIKE '%$search%' 
                  OR farmerCity LIKE '%$search%' 
                  OR farmerRegDate LIKE '%$search%' )";
    }
    
    $sql .= "ORDER BY farmerId DESC LIMIT $itemsPerPage OFFSET $offset";
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
               
                array_push($icarray, [
                    "farmerId" => $row["farmerId"],
                    "farmerName" => $row["farmerName"],
                    "farmerMobile" => $row["farmerMobile"],
                    "farmerAddress" => $row["farmerAddress"],
                    "farmerCity" => $row["farmerCity"],
                    "farmerRegDate" => $row["farmerRegDate"],
                    "farmerLandAcerage" => $row["farmerLandAcerage"],
                    "farmerSD" => $row["farmerSD"],
                    "farmerSDV" => $row["farmerSDV"],
                    "farmerFD" => $row["farmerFD"]
                    
                ]);
               
            }
            $response['farmerList'] = $icarray;
           
        } else {
            // response for last entry
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
       
        $response['Count'] = $rowCount; //count condition like all count or paginated count 
        $response['error'] = false;
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
    } else {
        $response['error'] = true;
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
?>
