<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include_once 'functions/getIds.php'; 
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorized access terminated!";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$revisitarray = [];


$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if (!empty($data["empId"]) && !empty($data["page"])) {
    $empid = $data["empId"];
    $fromDate = $data["date"].' 00:00:00';
    $toDate = $data["date"].' 23:59:59';
    
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    $sql = "SELECT 
            t1.*,
            t1.empId AS emp_id,
            t2.*,
            t3.*,
            t4.emp_name
            FROM 
                `tbl_revisit` t1
            LEFT JOIN 
                `tbl_farmer` t2 ON t2.`farmerId` = t1.`farmerId` 
            LEFT JOIN
                `tbl_category` t3 ON t3.`category_id` = t2.`farmerRegion`
            LEFT JOIN 
                `tbl_employee` t4 ON t4.`id` = t1.`empId`
            WHERE
                t1.`empId` = '$empid'
            AND
                t1.revisit_datetime BETWEEN '$fromDate' AND '$toDate'";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    // Search filter
    if(isset($data['search'])){
        $sql .= " AND ( 
                    t2.farmerName LIKE '%$search%' 
                    OR t2.farmerMobile LIKE '%$search%' 
                    OR t1.revisitPurpose LIKE '%$search%' 
                    OR t1.revisit_datetime LIKE '%$search%' 
                    OR t2.farmerCity LIKE '%$search%' 
                )";
    }
    
    $sql .= " ORDER BY t1.rid DESC LIMIT $itemsPerPage OFFSET $offset";

    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                array_push($revisitarray, [
                    "revisitId" => $row["rid"],
                    "farmerId" => $row["farmerId"],
                    "farmerName" => $row["farmerName"],
                    "farmerMobile" => $row["farmerMobile"],
                    "farmerCity" => $row["category_name"],
                    "farmerLandAcerage" => $row["farmerLandAcerage"],
                    "revisitPurpose" => $row["revisitPurpose"],
                    "revisit_datetime" => $row["revisit_datetime"],
                    "empId" => $row["emp_id"]
                ]);
            }
            $response['detail'] = $revisitarray;
            $response['Count']= $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg; 
        }
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg; 
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
?>
