<?php

//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include("./functions/getIds.php");

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";
$unauthorisedUserCode = 203;
$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorized access terminated!";

$data = json_decode(file_get_contents("php://input"), true);
$response = [];
$SDarray = [];

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if (!empty($data["empId"])) {
    
    $empid = $data["empId"];
    $date = $data["date"];
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    
    
    $sql = "SELECT 
                t2.farmerName,t2.farmerMobile,t2.farmerAddress,t2.farmerCity,t2.farmerId,
                t2.farmerSD,t2.farmerSDV,t1.SD_date,t1.cropId,t1.productId,t1.SDV_date,
                t1.faId,t2.farmerLocation,t1.SD_Flag,t1.SDV_Flag, 
                (SELECT emp_name FROM tbl_employee WHERE id = t1.empId) as empName 
            FROM `tbl_farmactivity` t1 
            LEFT JOIN `tbl_farmer` t2 
            ON `t1`.farmerId = `t2`.farmerId 
            WHERE `t1`.empId = $empid AND `t1`.SDV_date = '$date'";
    $search = isset($data['search']) ? $data['search'] : '';

    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t2.farmerName LIKE '%$search%' 
                  OR t2.farmerMobile LIKE '%$search%' 
                  OR t2.farmerAddress LIKE '%$search%' 
                  OR t2.farmerCity LIKE '%$search%' 
                  OR t1.SDV_date LIKE '%$search%' )";
    }
    
    $sql .= "ORDER BY faId DESC LIMIT $itemsPerPage OFFSET $offset";
    
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    $actualDataCounter = 0;

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {

                $sql11 = "SELECT * FROM tbl_crop WHERE cropId = '".$row["cropId"]."'";
                $query11 = mysqli_query($con, $sql11);
                $results11 = mysqli_fetch_object($query11);
                if ($results11) {
                    $cropName = $results11->cropName;
                } else {
                    $cropName = "";
                }

                $sql12 = "SELECT * FROM tbl_activity_product WHERE pid = '".$row["productId"]."'";
                $query12 = mysqli_query($con, $sql12);
                $results12 = mysqli_fetch_object($query12);
                if ($results12) {
                    $productName = $results12->productName;
                } else {
                    $productName = "";
                }

                array_push($SDarray, [
                    "faId" => $row["faId"],
                    "farmerId" => $row["farmerId"],
                    "farmerSD" => $row["farmerSD"],
                    "farmerSDV" => $row["farmerSDV"],
                    "crop" => $cropName,
                    "product" => $productName,
                    "SD_date" => $row["SD_date"],
                    "SDV_date" => $row["SDV_date"],
                    "farmerName" => $row["farmerName"],
                    "farmerMobile" => $row["farmerMobile"],
                    "farmerLocation" => $row["farmerLocation"],
                    "farmerAddress" => $row["farmerAddress"],
                    "farmerCity" => $row["farmerCity"],
                    "SD_Flag" => $row["SD_Flag"],
                    "SDV_Flag" => $row["SDV_Flag"],
                ]);
                
            }
            $response['SDList'] = $SDarray;
            
            
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
        $response['Count'] = $rowCount;
        $response['error'] = false;
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
    } else {
        $response['error'] = true;
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
