<?php

// error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include_once 'functions/getIds.php'; 
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";


$unauthorisedUserMsg = "Unauthorised access terminated !";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$todoListArray = [];
// 20.7116935,76.9958865
if (!empty($data["empId"]) && !empty($data["eid"]) && !empty($data["page"])) {
    $un = $data['eid'];
    $empId = $data['empId'];
   
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    $fromDate = date('Y-m-01');
    $toDate = date('Y-m-d');
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    

    $sql = "SELECT *
        FROM 
            `tbl_todolist` t1 
        WHERE 
            t1.uid = '$empId' 
        AND 
            t1.date BETWEEN  '$fromDate' AND '$toDate'";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t1.tasks LIKE '%$search%' 
                      OR t1.date LIKE '%$search%'
                  )";
    }
    
    $sql .= "  ORDER BY t1.created_at  DESC LIMIT $itemsPerPage OFFSET $offset";
    // echo $sql;
    $query11 = mysqli_query($con, $sql);
    $rowCount11 = mysqli_num_rows($query11);
    
    if ($query11) {
        if ($rowCount11 > 0) { 
            while ($row = mysqli_fetch_array($query11)) {
                if($row['status']=='1'){
                    $status = 'Completed';
                }else{
                    $status = 'Pending';
                }
                array_push(
                    $todoListArray,
                    [
                        "id" => $row['id'],
                        "task" => $row['tasks'],
                        "date" => $row['date'],
                        "statusCode" => $row['status'],
                        "status" => $status
                    ]
                );
            }
            $response['todoList'] = $todoListArray;
            $response['Count'] = $rowCount11;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['statu'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
