<?php

function calculateAttendanceFlag($stime, $etime, $shift) {
    $stime_ts = $stime ? strtotime($stime) : null;
    $etime_ts = $etime ? strtotime($etime) : null;

    $late_start_ts  = isset($shift['late_mark_start']) ? strtotime($shift['late_mark_start']) : 0;
    $late_end_ts    = isset($shift['late_mark_end'])   ? strtotime($shift['late_mark_end']) : 0;
    $half_day_ts    = isset($shift['half_day_time'])   ? strtotime($shift['half_day_time']) : 0;
    $early_start_ts = isset($shift['early_mark_start'])? strtotime($shift['early_mark_start']) : 0;
    $early_end_ts   = isset($shift['early_mark_end'])  ? strtotime($shift['early_mark_end']) : 0;
    $shift_end      = isset($shift['login_end'])  ? strtotime($shift['login_end']) : 0;
    $work_hour      = isset($shift['work_hour'])       ? strtotime($shift['work_hour']) - strtotime("00:00:00") : 8 * 3600;

    if ($stime_ts && !$etime_ts) {
        if ($stime_ts >= $late_start_ts && $stime_ts <= $late_end_ts) return 1; // Late login
        if ($stime_ts >= $late_end_ts && $stime_ts <= $half_day_ts) return 3; // Half Day S1
        if ($stime_ts > $half_day_ts) return 9;
        return 0; // Day started, Normal
    }


    // === CASE 2: Start + End present ===
    if ($stime_ts && $etime_ts) {
        $actual_worked = $etime_ts - $stime_ts;

        if ($etime_ts < $half_day_ts) {
            return 9; // Too short — below half day threshold
        }

        $isVeryLate  = ($stime_ts > $half_day_ts);
        $isLateLogin = ($stime_ts >= $late_start_ts && $stime_ts <= $late_end_ts);
        $isTooShort  = ($actual_worked < $work_hour);
        $isEarlyOut  = ($etime_ts > $half_day_ts && $etime_ts < $early_end_ts);

        // Prioritized flag logic
        if ($isEarlyOut && $isTooShort) return 6;  // Half Day S2 + Early Out
        if ($isEarlyOut) return 4;                 // Half Day S2
        if ($isTooShort) return 2;                 // Short hours

        //return 0; // Normal day
    }

    // === CASE 3: Neither time present (should not happen)
    return 9;
}

?>
