<?php

function distance($lat1, $lon1, $lat2, $lon2, $unit){
	
	if (empty($lat1) || empty($lon1) || empty($lat2) || empty($lon2)) {
        return 0; // or return 0, depending on your logic
    }
	
	if (($lat1 == $lat2) && ($lon1 == $lon2)) {
		return 0;
	} else {
		$theta = $lon1 - $lon2;
		$dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
		$dist = acos($dist);
		$dist = rad2deg($dist);
		$miles = $dist * 60 * 1.1515;
		$unit = strtoupper($unit);

		if ($unit == "K") {
			return ($miles * 1.609344);
		} else if ($unit == "N") {
			return ($miles * 0.8684);
		} else {
			return $miles;
		}
	}
} 

function insertLocationData($con,$lat,$long,$activity_time,$battery,$empId,$eid,$date,$deviceToken,$activityId,$activityType){ 
    
    $checkDayStartStatusQuery = "SELECT * FROM `tbl_daystart` WHERE `uid`='" . $empId . "' AND `date`='" . $date . "'";
	$checkDayStartStatusResult = mysqli_query($con,$checkDayStartStatusQuery);
	$checkDayStartStatusData = $checkDayStartStatusResult->fetch_object();
// 	echo $checkDayStartStatusData->status;
	if($checkDayStartStatusData->status == '0'){
    	$query132 = "SELECT * FROM `tbl_track` WHERE `eid`='" . $eid . "' AND `date`='" . $date . "'";
    	$result132 = mysqli_query($con,$query132);
    	$data132 = $result132->fetch_object();
    	$lltb1 = $data132->lastLatLong;
    	
    	$lasta12 = explode("/", $lltb1);
    	$last_lat = $lasta12[0];
    	$last_long = $lasta12[1];
    	//exit;
    // 	$dis += distance($last_lat, $last_long, $lat, $long, "K");
        
        $dis = distance($last_lat, $last_long, $lat, $long, "K") ?? 0;    	
    	$activityLatLong = $lat.'/'.$long;
    	$lltb = '#'.$activityLatLong.'/'.$activity_time.'/'.$battery;
        $activityGeotagVal = '#'.$activityLatLong.'/'.$activity_time.'/'.$activityType.'/'.$activityId;
        
    	$lastLatLong = $lat ."/". $long;
    	
    	$sqlDay = "UPDATE `tbl_daystart` 
    	            SET 
    	            `disgps` = `disgps` + $dis 
    	            WHERE 
    	            `uid`= $empId 
    	            AND 
    	            `date` = '$date'";
    	            
    	$resultDay = mysqli_query($con,$sqlDay);
    	if($activityId == ''){
        	$sql = "UPDATE tbl_track 
        	         SET 
        	         `lltb` = CONCAT(lltb,'$lltb'),
        	         `lastLatLong`='$lastLatLong' 
        	         WHERE 
        	         eid = '$eid' 
        	         AND 
        	         `date` = '$date'";
    	}else{
    	   $sql = "UPDATE tbl_track 
        	         SET 
        	         `lltb` = CONCAT(lltb,'$lltb'),
        	         `lastLatLong`='$lastLatLong' ,
        	         `activityGeotag` = CONCAT(`activityGeotag`, '$activityGeotagVal') 
        	         WHERE 
        	         eid = '$eid' 
        	         AND 
        	         `date` = '$date'";
    	}
    // 	echo $sql;
    	$result = mysqli_query($con,$sql);
    	$response = 200;
	}else if($activityType == '20' || $activityType == '20'){
	    
    	$query132 = "SELECT * FROM `tbl_track` WHERE `eid`='" . $eid . "' AND `date`='" . $date . "'";
    	$result132 = mysqli_query($con,$query132);
    	$data132 = $result132->fetch_object();
    	$lltb1 = $data132->lastLatLong;
    	
    	$lasta12 = explode("/", $lltb1);
    	$last_lat = $lasta12[0];
    	$last_long = $lasta12[1];
    	
    	$dis += distance($last_lat, $last_long, $lat, $long, "K");
    		
    	
    	$activityLatLong = $lat.'/'.$long;
    	$lltb = '#'.$activityLatLong.'/'.$activity_time.'/'.$battery;
        $activityGeotagVal = '#'.$activityLatLong.'/'.$activity_time.'/'.$activityType.'/'.$activityId;
        
    	$lastLatLong = $lat ."/". $long;
    	
    	$sqlDay = "UPDATE `tbl_daystart` 
    	            SET 
    	            `disgps` = `disgps` + $dis 
    	            WHERE 
    	            `uid`= $empId 
    	            AND 
    	            `date` = '$date'";
    	            
    	$resultDay = mysqli_query($con,$sqlDay);
    	if($activityId == ''){
        	$sql = "UPDATE tbl_track 
        	         SET 
        	         `device_token` = '$deviceToken',
        	         `lltb` = CONCAT(lltb,'$lltb'),
        	         `lastLatLong`='$lastLatLong' 
        	         WHERE 
        	         eid = '$eid' 
        	         AND 
        	         `date` = '$date'";
    	}else{
    	   $sql = "UPDATE tbl_track 
        	         SET 
        	         `device_token` = '$deviceToken',
        	         `lltb` = CONCAT(lltb,'$lltb'),
        	         `lastLatLong`='$lastLatLong' ,
        	         `activityGeotag` = CONCAT(`activityGeotag`, '$activityGeotagVal') 
        	         WHERE 
        	         eid = '$eid' 
        	         AND 
        	         `date` = '$date'";
    	}
    // 	echo $sql;
    	$result = mysqli_query($con,$sql);
    	$response = 200;
	}else{
	    $response = 201;
	}
	return $response;
}

// insert background location right now on hold

function insertBackgroundLocationData($con,$lat,$long,$activity_time,$battery,$empId,$eid,$date,$deviceToken){ 
    
	$query132 = "SELECT * FROM `tbl_track` WHERE `eid`='" . $eid . "' AND `date`='" . $date . "'";
	$result132 = mysqli_query($con,$query132);
	$data132 = $result132->fetch_object();
	$lltb1 = $data132->lastLatLong;
	
	$lasta12 = explode("/", $lltb1);
	$last_lat = $lasta12[0];
	$last_long = $lasta12[1];
	
	$dist_val = distance($last_lat, $last_long, $lat, $long, "K") ?? 0;
	$dis += $dist_val;
		
	
	$activityLatLong = $lat.'/'.$long;
	$lltb = '#'.$activityLatLong.'/'.$activity_time.'/'.$battery;
    
	$lastLatLong = $lat ."/". $long;
	
	$sqlDay = "UPDATE `tbl_daystart` 
	            SET 
	            `disgps` = `disgps` + $dis 
	            WHERE 
	            `uid`= $empId 
	            AND 
	            `date` = '$date'";
	            
	$resultDay = mysqli_query($con,$sqlDay);
	
    $sql = "UPDATE tbl_track 
    	         SET 
    	         `device_token` = '$deviceToken',
    	         `lltb` = CONCAT(lltb,'$lltb'),
    	         `lastLatLong`='$lastLatLong' 
    	         WHERE 
    	         eid = '$eid' 
    	         AND 
    	         `date` = '$date'";
	
	$result = mysqli_query($con,$sql);
}

function insertMultipleBackgroundLocationData($con, $locations, $empId, $eid, $date, $deviceToken) {
    // Fetch the last known LatLong once
    $query132 = "SELECT lastLatLong FROM `tbl_track` WHERE `eid` = '$eid' AND `date` = '$date'";
    $result132 = mysqli_query($con, $query132);
    
    if (!$result132 || mysqli_num_rows($result132) == 0) {
        return false; // No existing tracking data found
    }

    $data132 = mysqli_fetch_object($result132);
    $lastLatLong = $data132->lastLatLong ?? '0/0';

    list($last_lat, $last_long) = explode('/', $lastLatLong);
    $totalDistance = 0;
    $lltbEntries = [];

    foreach ($locations as $location) {
        $lat = $location['lat'];
        $long = $location['long'];
        $activity_time = $location['activity_time'];
        $battery = $location['battery'];

        // Calculate distance
        $dist = distance($last_lat, $last_long, $lat, $long, "K") ?? 0;
        $totalDistance += $dist;

        // Format lltb
        $activityLatLong = $lat . '/' . $long;
        $lltbEntries[] = '#' . $activityLatLong . '/' . $activity_time . '/' . $battery;

        // Update current lat/long
        $last_lat = $lat;
        $last_long = $long;
    }

    // Concatenate values
    $lltbString = implode('', $lltbEntries);
    $lastLatLong = $last_lat . '/' . $last_long;

    // Update tbl_daystart
    $sqlDay = "UPDATE `tbl_daystart` 
               SET `disgps` = `disgps` + $totalDistance 
               WHERE `uid` = $empId AND `date` = '$date'";
    $sqlDay_result = mysqli_query($con, $sqlDay);

    // Update tbl_track
    $sqlTrack = "UPDATE `tbl_track` 
                 SET `device_token` = '$deviceToken',
                     `lltb` = CONCAT(`lltb`, '$lltbString'),
                     `lastLatLong` = '$lastLatLong'
                 WHERE `eid` = '$eid' AND `date` = '$date'";
    $result = mysqli_query($con, $sqlTrack);

    // Return true if both queries succeeded
    return $sqlDay_result && $result;
}


?>