<?php
// error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';

$agencyArray = array();
$agencyDetailsArray = array();
$agencyDeleteList = array();
$agencyIdArray = array();
$response = array();
$aServerIdArray = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency registered successfully !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access teminated !";


$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access teminated !";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["empId"]) && !empty($data["eid"])) {
    
    $un = $data["eid"];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $agencyType = $data["aType"];
    $empid = $data["empId"];
    $agencyIds = str_replace("#", ",", $data["aServerId"]);

    if (empty($agencyIds)) {
        $aServerIdArray = [];
    } else {
        $aServerIdArray = explode(",", $agencyIds);
    }

    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empid' AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $desig = $row1["empDesignation"];
    $region = $row1["region"];

    $row = getRegionId($con,$region);

    $sql111 = "SELECT * 
        FROM 
        `tbl_agency` 
        LEFT JOIN 
        `tbl_category` 
        ON 
        `tbl_category`.category_id = `tbl_agency`.agencyRegion 
        WHERE 
        `tbl_agency`.`agencyRegion` IN ($row) 
        AND 
        `tbl_agency`.`agencyType` = '$agencyType'";

    $query111 = mysqli_query($con, $sql111);
    $rowCount111 = mysqli_num_rows($query111);

    $maxVal = 0;
    $actualDataCounter = 0;
    if ($query111) {
        if ($rowCount111 > 0) {
            while ($row = mysqli_fetch_array($query111)) {
                $agencyIdArray[] = $row["agencyId"];
                if ($maxVal < 501) {
                    if (in_array($row["agencyId"], $aServerIdArray)) {
                    } else {
                        
                        array_push(
                            $agencyArray,
                            array(
                                "agencyId" => htmlspecialchars(strip_tags($row["agencyId"])),
                                "agencyShopName" => htmlspecialchars(strip_tags($row["agencyShopName"])),
                                "agencyName" => htmlspecialchars(strip_tags($row["agencyName"])),
                                "agencyMobile" => htmlspecialchars(strip_tags($row["agencyMobile"])),
                                "agencyCity" => htmlspecialchars(strip_tags($row["agencyCity"])),
                                "regionName" => htmlspecialchars(strip_tags($row["category_name"])),
                                "agencyRegion" => htmlspecialchars(strip_tags($row["agencyRegion"])),
                                "agencyType" => htmlspecialchars(strip_tags($row["agencyType"])),
                                
                            )
                        );
                        
                        $actualDataCounter++;
                        $maxVal++;
                    }
                }
            }

            $response['updteMsg'] = $updateMsg;
            $response['agencyList'] = $agencyArray;
            $agencyDeleteList = array_values(array_diff($aServerIdArray, $agencyIdArray));
            if (empty($agencyDeleteList)) {
                $response['agencyDeleteList'] = [];
            } else {
                $response['agencyDeleteList'] = $agencyDeleteList;
            }
        } else {
            $response['update'] = "0";
            $response['updateMsg'] = $updateNotMsg;
            if (empty($aServerIdArray)) {
                $response['agencyDeleteList'] = [];
            } else {
                $response['agencyDeleteList'] = $aServerIdArray;
            }
        }
        if ($maxVal < 500) {
            $response['reRequest'] = "0";
            $response['update'] = "0";
        } else {
            $response['reRequest'] = "1"; // request again
            $response['update'] = "1";
        }
        $response['rowCount'] = $actualDataCounter;
        $response['error'] = false;
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
    } else {
        $response['error'] = true;
        $response['code'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['error'] = true;
    $response['code'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
