<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$agencyArray = [];
$agencyDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);

function format_date_difference($start_date, $end_date) {
    $start = new DateTime($start_date);
    $end = new DateTime($end_date);
    $interval = $start->diff($end);
    
    if ($interval->y > 0) {
        return $interval->y . " year" . ($interval->y > 1 ? "s" : "");
    } elseif ($interval->m > 0) {
        return $interval->m . " month" . ($interval->m > 1 ? "s" : "");
    } elseif ($interval->d > 0) {
        return $interval->d . " day" . ($interval->d > 1 ? "s" : "");
    } else {
        return "0 days";
    }
}

if (!empty($data["empId"])&& !empty($data["page"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $getRegionNameArray = getRegionNameArray($con);
    $cropValArry = getAllCropName('All',$con);
    
    $agencyType = $data["aType"];
    $empid = $data["empId"];
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = $empid AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $desig = $row1["empDesignation"];
    $region = $row1["region"];

    $row = getRegionId($con,$region);

    $sql = "SELECT t1.*, t2.agencyDetailId ,t4.agencyShopName as agencyDistributorName,t5.designation_name,t2.agencyWholesaleBrand,t2.agencyWholesalePer,t2.dso_payment
            FROM `tbl_agency` t1 
            LEFT JOIN (
                SELECT agencyId, MAX(agencyDetailId) AS maxAgencyDetailId
                FROM tbl_agencydetail 
                GROUP BY agencyId
            ) latest_agencydetail ON t1.agencyId = latest_agencydetail.agencyId
            LEFT JOIN tbl_agencydetail t2 
                ON latest_agencydetail.agencyId = t2.agencyId 
                AND latest_agencydetail.maxAgencyDetailId = t2.agencyDetailId
            LEFT JOIN tbl_agency t4 ON t1.agencyDistributor = t4.agencyId
            LEFT JOIN tbl_agency_designation t5 ON t1.designation = t5.id
            WHERE t1.`agencyRegion` IN ($row) 
            AND t1.`agencyType` = '$agencyType' 
            AND t1.approvstatus = 1";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t1.agencyShopName LIKE '%$search%' 
                  OR t1.agencyMobile LIKE '%$search%' 
                  OR t1.agencyAddress LIKE '%$search%' 
                   )";
    }
    
    $sql .= " ORDER BY t2.agencyDetailId DESC LIMIT $itemsPerPage OFFSET $offset";
    // exit;
    $query111 = mysqli_query($con, $sql);
    $rowCount111 = mysqli_num_rows($query111);

    if ($query111) {
        if ($rowCount111 > 0) {
            while ($row = mysqli_fetch_array($query111)) {
                
                
                $lastvisit_date = $row['lastVisitDateTime'];
                $current_date = date('Y-m-d');
                $lastVisitedTime = format_date_difference($lastvisit_date, $current_date); // Output: 1 month
                
                $regionName = '';
                if($row['agencyRegion']){
                    $key = '';
                    $key = array_search($row['agencyRegion'], array_column($getRegionNameArray, 'category_id'));
                    if ($key === FALSE) {
                        $regionName = '';
                    } else {
                        $regionName = $getRegionNameArray[$key]['category_name'];
                    }
                }
        
                $creditLimit = isset($row["creditLimit"]) ? $row["agencyId"] : null;
                $agencyLatLong = isset($row["latlong"]) ? $row["latlong"] : null;
                
                $cropString = explode('#',$row['croppingPattern']);
                $cropArray = array();
                for($i = 0;$i<count($cropString);$i++){
                    if($cropString[$i]){
                        $key = '';
                        $key = array_search($cropString[$i], array_column($cropValArry, 'cropId'));
                        if ($key === FALSE) {
                            $cropArray[] = '';
                        } else {
                            $cropArray[] = $cropValArry[$key]['cropName'];
                        }
                    }
                }
                
                array_push(
                    $agencyArray,
                    array(
                        "agencyId" => htmlspecialchars(strip_tags($row["agencyId"])),
                        "agencyDetailId" => htmlspecialchars(strip_tags($row["agencyDetailId"])),
                        "agencyShopName" => htmlspecialchars(strip_tags($row["agencyShopName"])),
                        "agencyName" => htmlspecialchars(strip_tags($row["agencyName"])),
                        "agencyMobile" => htmlspecialchars(strip_tags($row["agencyMobile"])),
                        "agencyEmail" => htmlspecialchars(strip_tags($row["agencyEmail"])),
                        "agencyAltNumber" => htmlspecialchars(strip_tags($row["agencyAltNumber"])),
                        "agencyLocation" => htmlspecialchars(strip_tags($row["agencyLocation"])),
                        "agencyAddress" => htmlspecialchars(strip_tags($row["agencyAddress"])),
                        "agencyCity" => htmlspecialchars(strip_tags($row["agencyCity"])),
                        "agencyPincode" => htmlspecialchars(strip_tags($row["agencyPincode"])),
                        "regionName" => $regionName,
                        "agencyRegion" => htmlspecialchars(strip_tags($row["agencyRegion"])),
                        "agencyType" => htmlspecialchars(strip_tags($row["agencyType"])),
                        "agencyDistributor" => htmlspecialchars(strip_tags($row["agencyDistributor"])),
                        "agencyDistributorName" => htmlspecialchars(strip_tags($row["agencyDistributorName"])),
                        "handling_business_since" => htmlspecialchars(strip_tags($row["handling_business_since"])),
                        "agencyDesignation" => htmlspecialchars(strip_tags($row["designation"])),
                        "designation_name" => htmlspecialchars(strip_tags($row["designation_name"])),
                        "distributorCode" => htmlspecialchars(strip_tags($row["distributorCode"])),
                        "noOfRetailers" => htmlspecialchars(strip_tags($row["noOfRetailers"])),
                        "pancard" => htmlspecialchars(strip_tags($row["pan"])),
                        "croppingPatternName" => $cropArray,
                        "croppingPattern" => $cropString,
                        //"agencyDetailId" => htmlspecialchars(strip_tags($row["agencyDetailId"])),
                        "lic1" => htmlspecialchars(strip_tags($row["licence1"])),
                        "lic2" => htmlspecialchars(strip_tags($row["licence2"])),
                        "lic3" => htmlspecialchars(strip_tags($row["licence3"])),
                        "gstNo" => htmlspecialchars(strip_tags($row["gst"])),
                        "agencyCategoryId" => htmlspecialchars(strip_tags($row["agencyCategoryId"])),
                        "approvstatus" => htmlspecialchars(strip_tags($row["approvstatus"])),
                        "discount" => htmlspecialchars(strip_tags($discount)),
                        "agencyLatLong" => $agencyLatLong,
                        "activity_time" => htmlspecialchars(strip_tags($row["activity_time"])),
                        "date" => htmlspecialchars(strip_tags($row["created_at"])),
                        "creditLimit" => $creditLimit,
                        "agencyWholesaleBrand" => htmlspecialchars(strip_tags($row["agencyWholesaleBrand"])),
                        "agencyWholesalePer" => htmlspecialchars(strip_tags($row["agencyWholesalePer"])),
                        "dso_payment" => htmlspecialchars(strip_tags($row["dso_payment"])),
                        "lastVisitData" => $lastVisitedTime .' ago',
                        
                    )
                );
                       
            }

            $response['agencyList'] = $agencyArray;
            $response['rowCount'] = $rowCount111;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
