<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$alertListArray = [];
$farmerProfileDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Alert List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);


if (!empty($data["regionId"])&& !empty($data["page"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $alertTypeValArr = getalertNameArray($con);
    $regionId = $data["regionId"];
    $getAllRegionId = getRegionId($con,$regionId);
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    

    $sql = "SELECT t1.* FROM 
                tbl_alert as t1 
           WHERE 
                regionId IN ($getAllRegionId)
            ";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t1.villageName LIKE '%$search%' 
                        OR alertDate LIKE '%$search%' 
                        
                   )";
    }
    
    $sql .= " ORDER BY t1.id DESC LIMIT $itemsPerPage OFFSET $offset";
    // exit;
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    //print_r($alertTypeValArr);
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                $alertTypeArray = [];
                $alertType = '';
                if($row['alertType']){
                    $alertType = explode('#',$row['alertType']);
                    $alertTypeCount = count($alertType);
                    if($alertTypeCount !=0){
                        for($i = 0;$i < $alertTypeCount;$i++){
                            $key = '';
                            $key = array_search($alertType[$i], array_column($alertTypeValArr, 'id'));
                            if ($key === FALSE) {
                                $alertTypeArray[] = '';
                            } else {
                                $alertTypeArray[] = $alertTypeValArr[$key]['alertName'];
                            }
                           
                        }
                    }
                }
                
                array_push(
                    $alertListArray,
                    array(
                        "id" => htmlspecialchars(strip_tags($row["id"])),
                        "villageName" => htmlspecialchars(strip_tags($row["villageName"])),
                        "alertTypeId" => $alertType,
                        "alertTypeName" => $alertTypeArray,
                        "date" => $row['alertDate'],
                        "activity_time" => htmlspecialchars(strip_tags($row["activity_time"])),
                        "severity" => htmlspecialchars(strip_tags($row["severity"])),
                    )
                );
                       
            }

            $response['alertList'] = $alertListArray;
            $response['rowCount'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
            $response['alertList'] = $alertListArray;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
