<?php
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

    include_once '../db_config/config1.php';
    include_once 'functions/getIds.php';

    $response = [];
    $product = [];

    $SuccessStatusCode = 200;
    $SuccessStatusMsg = "Successful!";
    $FailStatusCode = 202;
    $FailStatusMsg = "Credentials Incorrect!";

    $un = $_GET['eid'];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    if(!empty($_GET['empId']) && !empty($_GET['eid'])){
        try{
            $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
        }catch (Exception $e) {
            $response['status'] = $FailStatusCode;
            $response['message'] = "Database con error: " . $e->getMessage();
            
            //http_response_code(500);
            echo json_encode($response);
            exit;
        }


        // Get inputs
        $empid = isset($_GET['empid']) ? $_GET['empid'] : null;
        $parent = isset($_GET['parent']) ? $_GET['parent'] : null;
        $search = isset($_GET['search']) ? $_GET['search'] : null;
        $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
        $limit = 100;
        $offset = ($page - 1) * $limit;

        $empId = $_GET['empId'];
        $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId' AND `deleteFlag` = 0";
        $query1 = mysqli_query($con, $sql1);
        $row1 = mysqli_fetch_array($query1);
        $region = $row1["region"];
        $tallyAgencyArr = getAgencyTallyDistributorId($region,$con);
        $tallyDistributorId = implode(',',$tallyAgencyArr);

        // Validate parent input
        if (!in_array($parent, ['Credit Note', 'Debit Note', 'Sales', 'Payment'])) {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid parent value provided.',
            ]);
            exit;
        }

        // Build base query
        // Check if $tallyDistributorId is empty
        if (empty($tallyDistributorId)) {
            $distributorCondition = "AND 1 = 0";  // This ensures no records are returned
        } else {
            $distributorCondition = "AND DistributorIdVal IN ($tallyDistributorId)";
        }
        
        // Main query
        $query = "
            SELECT 
                trn_voucher.voucher_type,
                trn_voucher.guid,
                trn_voucher.date,
                trn_voucher.voucher_number,
                trn_accounting.amount,
                trn_accounting.ledger
            FROM trn_voucher
            INNER JOIN mst_vouchertype ON trn_voucher.voucher_type = mst_vouchertype.name
            INNER JOIN trn_accounting 
                ON trn_voucher.guid = trn_accounting.guid 
                AND trn_voucher.party_name = trn_accounting.ledger
            LEFT JOIN mst_ledger ON mst_ledger.name = trn_voucher.party_name
            WHERE 1=1
            $distributorCondition
        ";


        // Add conditions based on parent
        if (in_array($parent, ['Payment', 'Debit Note', 'Credit Note'])) {
            $query .= " AND trn_voucher.voucher_type = '" . mysqli_real_escape_string($con, $parent) . "'";
        } elseif ($parent === 'Sales') {
            $query .= "
                AND mst_vouchertype.parent = 'Sales'
                AND trn_voucher.voucher_type = mst_vouchertype.name
            ";
        }

        // Add search condition if provided
        if (!empty($search)) {
            $query .= " AND trn_accounting.ledger LIKE '%" . mysqli_real_escape_string($con, $search) . "%'";
        }

        // Add ordering
        $query .= " ORDER BY trn_voucher.date LIMIT $limit OFFSET $offset";

        // Execute query
        $result = mysqli_query($con, $query);
        if (!$result) {
            echo json_encode([
                'success' => false,
                'message' => 'Something went wrong.',
            ]);
            exit;
        }

        // Fetch data
        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }

        // Fetch timestamp
        $configQuery = "SELECT value,name FROM config WHERE name = 'Update Timestamp'";
        $configResult = mysqli_query($con, $configQuery);
        $timestamp = $configResult ? mysqli_fetch_assoc($configResult) : null;

        // Return response
        if (empty($data)) {
            echo json_encode([
                'success' => false,
                'message' => 'No records found with the specified voucher types and matching guid.',
            ]);
        } else {
            echo json_encode([
                'success' => true,
                'message' => 'Data retrieved successfully.',
                'code' => 200,
                'data' => $data,
                'timestamp' => $timestamp,
            ]);
        }
    }else{
        echo json_encode([
            'success' => true,
            'message' => 'Fields are missing.',
            'code' => 200,
            'data' => []
        ]);
    }

