<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$beatPlanDetail = [];
$farmerbeatPlanDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "farmerbeatPlan List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["eid"])&& !empty($data["beatPlanId"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $beatPlanId = $data['beatPlanId'];
    
    $sql = "SELECT t1.*, t4.CustomerType as customerTypeName,t5.activity_name,t6.purpose_name,
                       CASE
                           WHEN t1.customerType = '1' THEN t2.farmerName
                           WHEN t1.customerType = '2' THEN t3.agencyName
                           ELSE NULL
                       END AS clientName        
                FROM  tbl_beat_planning AS t1
                LEFT JOIN tbl_farmer AS t2 ON t2.farmerId = t1.clientId AND t1.customerType = '1'
                LEFT JOIN tbl_agency AS t3 ON t3.agencyId = t1.clientId AND t1.customerType = '2'
                LEFT JOIN tbl_beatPlanning_customerType AS t4 ON t4.id = t1.customerType 
                LEFT JOIN tbl_farmer_activity AS t5 ON t5.id = t1.farmerActivityType 
                LEFT JOIN tbl_office_work_pupose AS t6 ON t6.id = t1.purposeId 
                WHERE 
                t1.id = '$beatPlanId' ";
    
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                
                array_push(
                    $beatPlanDetail,
                    array(
                        "id" => htmlspecialchars(strip_tags($row["id"])),
                        "customerTypeId" => htmlspecialchars(strip_tags($row["customeType"])),
                        "customerTypeName" => htmlspecialchars(strip_tags($row["customerTypeName"])),
                        "farmerActivityType" => htmlspecialchars(strip_tags($row["farmerActivityType"])),
                        "farmerActivityName" => htmlspecialchars(strip_tags($row["activity_name"])),
                        "clientId" => htmlspecialchars(strip_tags($row["clientId"])),
                        "clientName" => htmlspecialchars(strip_tags($row["clientName"])),
                        "purpose_name" => htmlspecialchars(strip_tags($row["purpose_name"])),
                        "villageName" => htmlspecialchars(strip_tags($row["villageName"])),
                        "otherWork" => htmlspecialchars(strip_tags($row["otherWork"])),
                        "latlong" => htmlspecialchars(strip_tags($row["latlong"])),
                        "date" => htmlspecialchars(strip_tags($row["date"])),
                        "activity_time" => htmlspecialchars(strip_tags($row["activity_time"]))
                    )
                );
                       
            }

            $response['beatPlanDetails'] = $beatPlanDetail;
            $response['rowCount'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
