<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';



$response = [];
$product = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$FailStatusCode = 202;
$FailStatusMsg = "Credentials Incorrect!";

$un = $_GET['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
if(!empty($_GET['empId']) && !empty($_GET['eid'])){
    try{
        $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    }catch (Exception $e) {
        $response['status'] = $FailStatusCode;
        $response['message'] = "Database con error: " . $e->getMessage();
        
        //http_response_code(500);
        echo json_encode($response);
        exit;
    }

    $empId = $_GET['empId'];
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId' AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
    $tallyAgencyArr = getAgencyTallyDistributorId($region,$con);
    $tallyDistributorId = implode(',',$tallyAgencyArr);

    
    // Check if $tallyDistributorId is empty
    if (empty($tallyDistributorId)) {
        $distributorCondition = "AND 1 = 0";  // This ensures no records are returned
    } else {
        $distributorCondition = "AND DistributorIdVal IN ($tallyDistributorId)";
    }
    
    // Queries to calculate totals
    // Payment Query
    $paymentQuery = "
        SELECT SUM(trn_accounting.amount) AS total_payment_amount
        FROM trn_voucher
        INNER JOIN mst_vouchertype ON trn_voucher.voucher_type = mst_vouchertype.parent
        INNER JOIN trn_accounting ON trn_voucher.guid = trn_accounting.guid 
            AND trn_voucher.party_name = trn_accounting.ledger
        LEFT JOIN mst_ledger ON mst_ledger.name = trn_voucher.party_name
        WHERE 1=1
        $distributorCondition
        AND mst_vouchertype.parent = 'Payment'
    ";
    
    // Billing Query
    $billingQuery = "
        SELECT SUM(trn_accounting.amount) AS total_billing_amount
        FROM trn_voucher
        INNER JOIN mst_vouchertype ON trn_voucher.voucher_type = mst_vouchertype.name
        INNER JOIN trn_accounting ON trn_voucher.guid = trn_accounting.guid 
            AND trn_voucher.party_name = trn_accounting.ledger
        LEFT JOIN mst_ledger ON mst_ledger.name = trn_voucher.party_name
        WHERE 1=1
        $distributorCondition
        AND mst_vouchertype.parent = 'Sales'
        AND trn_voucher.voucher_type IN (
            SELECT name FROM mst_vouchertype WHERE parent = 'Sales'
        )
    ";
    
    // Credit Note Query
    $creditNoteQuery = "
        SELECT SUM(trn_accounting.amount) AS total_credit_note_amount
        FROM trn_voucher
        INNER JOIN mst_vouchertype ON trn_voucher.voucher_type = mst_vouchertype.parent
        INNER JOIN trn_accounting ON trn_voucher.guid = trn_accounting.guid 
            AND trn_voucher.party_name = trn_accounting.ledger
        LEFT JOIN mst_ledger ON mst_ledger.name = trn_voucher.party_name
        WHERE 1=1
        $distributorCondition
        AND mst_vouchertype.parent = 'Credit Note'
    ";
    
    // Debit Note Query
    $debitNoteQuery = "
        SELECT SUM(trn_accounting.amount) AS total_debit_note_amount
        FROM trn_voucher
        INNER JOIN mst_vouchertype ON trn_voucher.voucher_type = mst_vouchertype.parent
        INNER JOIN trn_accounting ON trn_voucher.guid = trn_accounting.guid 
            AND trn_voucher.party_name = trn_accounting.ledger
        LEFT JOIN mst_ledger ON mst_ledger.name = trn_voucher.party_name
        WHERE 1=1
        $distributorCondition
        AND mst_vouchertype.parent = 'Debit Note'
    ";


    // Execute queries and fetch results
    $paymentResult = mysqli_query($con, $paymentQuery);
    $billingResult = mysqli_query($con, $billingQuery);
    $creditNoteResult = mysqli_query($con, $creditNoteQuery);
    $debitNoteResult = mysqli_query($con, $debitNoteQuery);

    $paymentAmount = mysqli_fetch_assoc($paymentResult)['total_payment_amount'] ?? 0;
    $billingAmount = mysqli_fetch_assoc($billingResult)['total_billing_amount'] ?? 0;
    $creditNoteAmount = mysqli_fetch_assoc($creditNoteResult)['total_credit_note_amount'] ?? 0;
    $debitNoteAmount = mysqli_fetch_assoc($debitNoteResult)['total_debit_note_amount'] ?? 0;

    // Fetch period range from config table
    $configQuery = "
        SELECT name, value
        FROM config
        WHERE name IN ('Period From', 'Period To', 'Update Timestamp')
    ";
    $configResult = mysqli_query($con, $configQuery);

    $periodFrom = null;
    $periodTo = null;
    $timestamp = null;

    while ($row = mysqli_fetch_assoc($configResult)) {
        if ($row['name'] === 'Period From') {
            $periodFrom = $row['value'];
        }
        if ($row['name'] === 'Period To') {
            $periodTo = $row['value'];
        }
        if ($row['name'] === 'Update Timestamp') {
            $timestamp = [
                "name" => $row['name'],
                "value" => date("d/m/Y, h:i:s a", strtotime($row['value'])) // Formatting the timestamp
            ];
        }
    }

    $periodRange = $periodFrom && $periodTo ? "{$periodFrom} - {$periodTo}" : null;

    // Prepare response
    echo json_encode([
        'success' => true,
        'message' => 'Data retrieved successfully.',
        'code' => 200,
        'data' => [
            [
                'name' => 'Payment',
                'value' => (string)abs($paymentAmount),
            ],
            [
                'name' => 'Sales',
                'value' => (string)abs($billingAmount),
            ],
            [
                'name' => 'Credit Note',
                'value' => (string)abs($creditNoteAmount),
            ],
            [
                'name' => 'Debit Note',
                'value' => (string)abs($debitNoteAmount),
            ],
        ],
        'period_range' => $periodRange,
        'timestamp' => $timestamp,
    ]);
}else{
    echo json_encode([
        'success' => true,
        'message' => 'Fields are missing.',
        'code' => 200,
        'data' => []
    ]);
}
