<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$complaintListArray = [];
$farmerProfileDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Beat Planning List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);


if (!empty($data["regionId"])&& !empty($data["page"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $complaintTypeValArr = getComplaintNameArray($con);
    $regionId = $data["regionId"];
    $getAllRegionId = getRegionId($con,$regionId);
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    

    $sql = "SELECT t1.*,t2.farmerName,t3.productName FROM 
                tbl_complaints as t1 
            LEFT JOIN 
                tbl_farmer as t2 ON t1.farmerId = t2.farmerId
            LEFT JOIN 
                tbl_activity_product as t3 ON t1.productId = t3.pid
            WHERE 
                regionId IN ($getAllRegionId)
            ";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t2.farmerName LIKE '%$search%' 
                        OR complaintDate LIKE '%$search%' 
                        OR productName LIKE '%$search%' 
                   )";
    }
    
    $sql .= " ORDER BY t1.id DESC LIMIT $itemsPerPage OFFSET $offset";
    // exit;
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                $complaintTypeArray = '';
                $complaintType = '';
                if($row['complaintType']){
                    $complaintType = $row['complaintType'];
                    //$complaintTypeCount = count($complaintType);
                    
                    if($complaintType){
                        $key = '';
                        $key = array_search($complaintType, array_column($complaintTypeValArr, 'id'));
                        if ($key === FALSE) {
                            $complaintTypeArray = '';
                        } else {
                            $complaintTypeArray = $complaintTypeValArr[$key]['complaintName'];
                        }
                    }
                   
                }
                
                array_push(
                    $complaintListArray,
                    array(
                        "id" => htmlspecialchars(strip_tags($row["id"])),
                        "farmerId" => htmlspecialchars(strip_tags($row["farmerId"])),
                        "farmerName" => htmlspecialchars(strip_tags($row["farmerName"])),
                        "productId" => htmlspecialchars(strip_tags($row["productId"])),
                        "productName" => htmlspecialchars(strip_tags($row["productName"])),
                        "complaintTypeId" => $complaintType,
                        "complaintTypeName" => $complaintTypeArray,
                        "date" => $row['complaintDate'],
                        "activity_time" => htmlspecialchars(strip_tags($row["activity_time"])),
                        "severity" => htmlspecialchars(strip_tags($row["severity"])),
                    )
                );
                       
            }

            $response['complaintList'] = $complaintListArray;
            $response['rowCount'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
            $response['complaintList'] = $complaintListArray;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
