<?php

// error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include_once 'functions/getIds.php'; 
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";


$unauthorisedUserMsg = "Unauthorised access terminated !";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$obListArray = [];

if (!empty($data["empId"]) && !empty($data["eid"]) && !empty($data["page"])) {
    $un = $data['eid'];
    $type = $data["agencyType"];
    $empId = $data["empId"];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $curDate = date('Y-m-d');
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    

    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId' AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];

    $rid = getRegionId($con,$region);
    
    $sql2 = "SELECT * FROM `tbl_employee` WHERE `region` IN ($rid) AND `deleteFlag` = 0";
    $query2 = mysqli_query($con, $sql2);
    $count2 = mysqli_num_rows($query2);
    $row2 = '';
    while ($rs1 = mysqli_fetch_array($query2)) {
        $row2 .= $rs1['id'] . ",";
    }
    $row2 = substr($row2, 0, -1);

    $sql = "SELECT t1.*, t2.agencyShopName,
            (SELECT `emp_name` 
                        FROM 
                        `tbl_employee` 
                        WHERE 
                        `id` = t1.emp_id) AS empName 
        FROM `tbl_ordernew` t1
        LEFT JOIN `tbl_agency` t2 ON t1.did = t2.agencyId
        WHERE t1.emp_id IN ($row2)
        AND t2.`agencyType` IN ($type)
        AND t1.date = '$curDate'";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t2.agencyShopName LIKE '%$search%' 
                  OR t1.date LIKE '%$search%' )";
    }
    
    $sql .= " ORDER BY t1.oid DESC LIMIT $itemsPerPage OFFSET $offset";
    // echo $sql;
    $query11 = mysqli_query($con, $sql);
    $rowCount11 = mysqli_num_rows($query11);
    
    if ($query11) {
        if ($rowCount11 > 0) {
            while ($row = mysqli_fetch_array($query11)) {
                
                if ($row['approval'] == '0') {
                    $status = 'pending';
                } elseif ($row['approval'] == '1') {
                    $status = 'approved';
                } elseif ($row['approval'] == '2') {
                    $status = 'delivered';
                } elseif ($row['approval'] == '9') {
                    $status = 'not ordered';
                }
                
                array_push(
                    $obListArray,
                    [
                        "rowid" => $row['oid'],
                        "agencyId" => $row['did'],
                        "agencyName" => $row['agencyShopName'],
                        "empName" => $row['empName'],
                        "agencyType" => $row['agencyType'],
                        "status" => $status,
                        "date" => $row['date']
                    ]
                );
            }
            $response['obVisitList'] = $obListArray;
            $response['Count'] = $rowCount11;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['statu'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
