<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$agencyArray = [];
$agencyDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["empId"])&& !empty($data["page"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $getRegionNameArray = getRegionNameArray($con);
    $agencyType = $data["aType"];
    $empid = $data["empId"];
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = $empid AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $desig = $row1["empDesignation"];
    $region = $row1["region"];

    $row = getRegionId($con,$region);

    $sql = "SELECT t2.*,t1.agencyDetailId,t1.dealer_profile_activity_time,t1.date,t1.dealer_profile_latlong  FROM 
                `tbl_agencydetail` t1
            LEFT JOIN tbl_agency t2
            ON t1.agencyId = t2.agencyId
            WHERE t1.agencyTurnover !=''
            AND
                t2.`agencyRegion` IN ($row) 
            AND 
                t2.approvstatus = 1 ";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( agencyShopName LIKE '%$search%' 
                  OR agencyMobile LIKE '%$search%' 
                  OR agencyAddress LIKE '%$search%' 
                   )";
    }
    
    $sql .= " ORDER BY t1.agencyDetailId DESC LIMIT $itemsPerPage OFFSET $offset";
    // exit;
    $query111 = mysqli_query($con, $sql);
    $rowCount111 = mysqli_num_rows($query111);

    if ($query111) {
        if ($rowCount111 > 0) {
            while ($row = mysqli_fetch_array($query111)) {
                // print_r($row);
                $regionName = '';
                if($row['agencyRegion']){
                    $key = '';
                    $key = array_search($row['agencyRegion'], array_column($getRegionNameArray, 'category_id'));
                    if ($key === FALSE) {
                        $regionName = '';
                    } else {
                        $regionName = $getRegionNameArray[$key]['category_name'];
                    }
                }
        
                $creditLimit = isset($row["creditLimit"]) ? $row["creditLimit"] : null;
                $agencyLatLong = isset($row["latlong"]) ? $row["latlong"] : null;
                
                array_push(
                    $agencyArray,
                    array(
                        "agencyId" => htmlspecialchars(strip_tags($row["agencyId"])),
                        "agencyDetailId" => htmlspecialchars(strip_tags($row["agencyDetailId"])),
                        "agencyShopName" => htmlspecialchars(strip_tags($row["agencyShopName"])),
                        "agencyName" => htmlspecialchars(strip_tags($row["agencyName"])),
                        "agencyMobile" => htmlspecialchars(strip_tags($row["agencyMobile"])),
                        "agencyAltNumber" => htmlspecialchars(strip_tags($row["agencyAltNumber"])),
                        //"agencyLocation" => htmlspecialchars(strip_tags($row["agencyLocation"])),
                        "agencyLocation" => htmlspecialchars(strip_tags(str_replace(",", "#", $row["agencyLocation"]))),
                        "agencyAddress" => htmlspecialchars(strip_tags($row["agencyAddress"])),
                        "agencyCity" => htmlspecialchars(strip_tags($row["agencyCity"])),
                        "agencyPincode" => htmlspecialchars(strip_tags($row["agencyPincode"])),
                        "regionName" => $regionName,
                        "agencyRegion" => htmlspecialchars(strip_tags($row["agencyRegion"])),
                        "agencyType" => htmlspecialchars(strip_tags($row["agencyType"])),
                        "agencyDistributor" => htmlspecialchars(strip_tags($row["agencyDistributor"])),
                        "agencyDetailId" => htmlspecialchars(strip_tags($row["agencyDetailId"])),
                        "lic1" => htmlspecialchars(strip_tags($row["licence1"])),
                        "lic2" => htmlspecialchars(strip_tags($row["licence1"])),
                        "lic3" => htmlspecialchars(strip_tags($row["licence1"])),
                        "gstNo" => htmlspecialchars(strip_tags($row["gst"])),
                        "agencyCategoryId" => htmlspecialchars(strip_tags($row["agencyCategoryId"])),
                        "approvstatus" => htmlspecialchars(strip_tags($row["approvstatus"])),
                        "discount" => htmlspecialchars(strip_tags($discount)),
                        "agencyLatLong" => $agencyLatLong,
                        "creditLimit" => $creditLimit,
                        "date" => htmlspecialchars(strip_tags($row["date"])),
                        "dealer_profile_activity_time" => htmlspecialchars(strip_tags($row["dealer_profile_activity_time"])),
                        "dealer_profile_latlong" => htmlspecialchars(strip_tags($row["dealer_profile_latlong"]))
                    )
                );
                       
            }
            //$modifiedString = str_replace(",", "#", $row["agencyLocation"]);

            $response['agencyList'] = $agencyArray;
            $response['rowCount'] = $rowCount111;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
