<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';
//$data = array();
 
$farmerProfileArray = [];
$farmerProfileDetailsArray = [];

$response = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "farmerProfile List !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["eid"])&& !empty($data["farmerId"])&& !empty($data["seasonId"])) {
    $un = $data['eid'];
    
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $farmerId = $data['farmerId'];
    
    $cropValArray = getAllCropName('All',$con);
    
    
    $seasonId = $data['seasonId'];
    
    $sql = "SELECT t1.*,t2.farmerName, t2.farmerCity,t3.* FROM 
                `tbl_farmer_profiling` t1
            LEFT JOIN tbl_farmer t2
            ON t1.farmerId = t2.farmerId
            LEFT JOIN tbl_farmerProfilingSeason t3
            ON t1.seasonId = t3.id
            WHERE t1.`farmerId` = '$farmerId' AND t1.seasonId = '$seasonId' ORDER BY farmerProfileDate DESC LIMIT 1 ";
    
    // echo $sql ;
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);

    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                $cropString = explode("#",$row['cropId']);
                $acerageArray = explode("#",$row['acerage']);
                
                $cropArray = array();
                for($i = 0;$i<count($cropString);$i++){
                    $cropString[$i];
                    if($cropString[$i]){
                        $key = '';
                        $key = array_search($cropString[$i], array_column($cropValArray, 'cropId'));
                        if ($key === FALSE) {
                            $cropArray[] = '';
                        } else {
                            $cropArray[] = $cropValArray[$key]['cropName'];
                        }
                    }
                }
                
                array_push(
                    $farmerProfileArray,
                    array(
                        "id" => htmlspecialchars(strip_tags($row["id"])),
                        "farmerName" => htmlspecialchars(strip_tags($row["farmerName"])),
                        "farmerId" => htmlspecialchars(strip_tags($row["farmerId"])),
                        "seasonName" => htmlspecialchars(strip_tags($row["durationName"])),
                        "seasonTimeFrom" => htmlspecialchars(strip_tags($row["fromDuration"])),
                        "seasonTimeTo" => htmlspecialchars(strip_tags($row["toDuration"])),
                        // "cropId" => htmlspecialchars(strip_tags($row["cropId"])),
                        "cropNameArray" => $cropArray,
                        "acerage" => $acerageArray,
                        "farmerCity" => htmlspecialchars(strip_tags($row["farmerCity"])),
                        "farmerProfileDate" => htmlspecialchars(strip_tags($row["farmerProfileDate"])),
                        "activity_time" => htmlspecialchars(strip_tags($row["activity_time"]))
                    )
                );
                       
            }

            $response['farmerProfileList'] = $farmerProfileArray;
            $response['rowCount'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['status'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
