<?php
//error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = array();
$purpose = array();
$SuccessStatusCode = 200;
$SuccessStatusMsg = "' Successful !";
$FailStatusCode = 202;
$FailStatusMsg = "Credentials Incorrect !";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["eid"]) && !empty($data["empId"])) {
    $uid = $data['empId'];
    $emp_id = $uid;
    $un = $data['eid'];
    $un1 = (explode("-", $un));
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

    if ($con->connect_error) {
        echo json_encode(['error' => true, 'message' => 'DB connection failed: ' . $con->connect_error]);
        exit;
    }

    // Determine financial year start and end
    $currentDate = date('Y-m-d');
    $currentYear = date('Y', strtotime($currentDate));
    if($un1[0] == 'frts'){
        $fyStart = $currentYear . '-01-01';
        $fyEnd = $currentYear . '-12-31';
    }else{
        $fyStart = (date('n') < 4) ? ($currentYear - 1) . '-04-01' : $currentYear . '-04-01';
        $fyEnd   = (date('n') < 4) ? $currentYear . '-03-31' : ($currentYear + 1) . '-03-31';
    }
    
    // Get employee designation and leave allotment type
    $empQuery = $con->query("SELECT empDesignation, leave_allotment_type FROM tbl_employee WHERE id = '$emp_id'");
    if (!$empQuery || $empQuery->num_rows == 0) {
        echo json_encode(['error' => true, 'message' => 'Employee not found']);
        exit;
    }
    $emp = $empQuery->fetch_assoc();
    $designationId = $emp['empDesignation'];
    $allotmentType = isset($emp['leave_allotment_type']) ? $emp['leave_allotment_type'] : 1;

    // Step 1: Get all leave types (even if not taken by employee)
    $allLeaveTypesSql = "SELECT id AS leave_type_id, leavetype FROM tbl_leavetype WHERE isDeleted = 0 ORDER BY leavetype ASC";
    $leaveTypesResult = $con->query($allLeaveTypesSql);
    
    $leaveSummary = [];
    $totalTaken = $totalAllotted = $totalRemaining = 0;
    
    if ($leaveTypesResult && $leaveTypesResult->num_rows > 0) {
        while ($typeRow = $leaveTypesResult->fetch_assoc()) {
            $leaveTypeId = $typeRow['leave_type_id'];
            $leavetype = $typeRow['leavetype'];
    
            // Step 2: Get leaves taken for this type
            $leaveTakenSql = "
                SELECT 
                    SUM(total_days) AS leavesTaken
                FROM tbl_leave_application
                WHERE emp_id = '$emp_id'
                  AND leave_type_id = '$leaveTypeId'
                  AND isApproved = 1
                  AND leave_status = 1
                  AND leave_from BETWEEN '$fyStart' AND '$fyEnd'
            ";
            $takenResult = $con->query($leaveTakenSql);
            $takenRow = $takenResult->fetch_assoc();
            $taken = floatval($takenRow['leavesTaken'] ?? 0);
    
            // Step 3: Get allotted leaves
            if ($allotmentType == 2) {
                $allotQuery = "
                    SELECT COALESCE(SUM(leaveCount), 0) AS allotted 
                    FROM tbl_emp_allotted_leave 
                    WHERE emp_id = '$emp_id' 
                      AND leaveType = '$leaveTypeId' 
                      AND isDeleted = 0 
                      AND add_to_table = 1
                ";
            } else {
                $allotQuery = "
                    SELECT COALESCE(SUM(leaveCount), 0) AS allotted 
                    FROM tbl_designation_wise_leave 
                    WHERE designationId = '$designationId' 
                      AND leaveType = '$leaveTypeId' 
                      AND isDeleted = 0 
                      AND add_to_table = 1
                ";
            }
    
            $allotResult = $con->query($allotQuery);
            $allotted = ($allotResult && $allotRow = $allotResult->fetch_assoc()) ? floatval($allotRow['allotted']) : 0;
    
            $remaining = round($allotted - $taken, 2);
    
            $leaveSummary[] = [
                'leave_type_id'     => $leaveTypeId,
                'leave_reason'      => $leavetype,
                'leavesRemaining'   => $remaining
            ];
    
            $totalTaken += $taken;
            $totalAllotted += $allotted;
            $totalRemaining += $remaining;
        }
    
        // Optional: Add LWP
        $leaveSummary[] = [
            'leave_type_id'     => 99,
            'leave_reason'      => 'Leave without pay ',
            'leavesRemaining'   => ''
        ];
    }
    // $response = $leaveSummary;
    $response = [
        'error' => false,
        'message' => 'Leave summary fetched successfully',
        'data' => $leaveSummary,
        'totals' => [
            'totalLeavesAllotted'   => $totalAllotted,
            'totalLeavesTaken'      => $totalTaken,
            'totalLeavesRemaining'  => $totalRemaining
        ]
    ];
}else {
    $response = ['error' => true, 'message' => 'Required parameters eid and empId are missing'];
}

echo json_encode($response);
exit;


?>