<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';

$response = [];
$product = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$FailStatusCode = 202;
$FailStatusMsg = "Credentials Incorrect!";


$un = $_GET['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
if(!empty($_GET['empId']) && !empty($_GET['eid'])){
    try{
        $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    }catch (Exception $e) {
        $response['status'] = $FailStatusCode;
        $response['message'] = "Database con error: " . $e->getMessage();
        
        //http_response_code(500);
        echo json_encode($response);
        exit;
    }


    // Input parameters
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 300;
    $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $offset = ($page - 1) * $limit;
    $search = isset($_GET['search']) ? $_GET['search'] : null;
    $empId = $_GET['empId'];
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empId' AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];
    $tallyAgencyArr = getAgencyTallyDistributorId($region,$con);
    //print_r($tallyAgencyArr);
    $tallyDistributorId = implode(',',$tallyAgencyArr);
    //exit;
    // Base query
    
    if (empty($tallyDistributorId)) {
        // If the array is empty, use a condition that will never match
        $query = "SELECT 
                    mst_ledger.guid, 
                    mst_ledger.name, 
                    mst_ledger.closing_balance, 
                    mst_ledger.opening_balance 
                  FROM mst_ledger 
                  INNER JOIN mst_group ON mst_group.name = mst_ledger.parent 
                  WHERE mst_group.primary_group IN ('Sundry Debtors', 'Sundry Creditors') 
                  AND mst_ledger.name != 'Profit & Loss A/c'
                  AND 1 = 0"; // This ensures no records are returned
    } else {
        // If the array is not empty, include the DistributorIdVal IN condition
        $query = "SELECT 
                    mst_ledger.guid, 
                    mst_ledger.name, 
                    mst_ledger.closing_balance, 
                    mst_ledger.opening_balance 
                  FROM mst_ledger 
                  INNER JOIN mst_group ON mst_group.name = mst_ledger.parent 
                  WHERE mst_group.primary_group IN ('Sundry Debtors', 'Sundry Creditors') 
                  AND mst_ledger.name != 'Profit & Loss A/c'
                  AND DistributorIdVal IN ($tallyDistributorId)";
    }

    // Debugging: echo the query
    //echo $query;

    // Add search condition
    if ($search) {
        $query .= " AND mst_ledger.name LIKE '%" . mysqli_real_escape_string($con, $search) . "%'";
    }

    // Count total records
    $countResult = mysqli_query($con, $query);
    $total = mysqli_num_rows($countResult);

    // Add ordering, limit, and offset
    $query .= " ORDER BY mst_ledger.guid ASC LIMIT $limit OFFSET $offset";

    // Execute main query
    $result = mysqli_query($con, $query);

    $data = [];
    $outstanding = 0;

    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $row['amount'] = number_format((float)$row['closing_balance'], 3, '.', '');
            $outstanding += (float)$row['amount'];
            $data[] = $row;
        }
    }

    // Fetch Config Data
    $configQuery = "SELECT name, value FROM config WHERE name = 'Update Timestamp' LIMIT 1";
    $configResult = mysqli_query($con, $configQuery);
    $configData = mysqli_fetch_assoc($configResult);

    // Prepare response
    if (!empty($data)) {
        $response = [
            'code' => 200,
            'error' => false,
            'message' => "Data fetched successfully",
            'total' => $total,
            'data' => $data,
            'outstanding' => abs(number_format($outstanding, 3, '.', '')),
            'pagination' => [
                'current_page' => $page,
                'per_page' => $limit,
                'total_pages' => ceil($total / $limit),
            ],
            'timestamp' => $configData,
        ];
    } else {
        $response = [
            'code' => 200,
            'error' => false,
            'message' => "No data found!",
            'total' => $total,
            'data' => [],
            'outstanding' => 0,
            'pagination' => [
                'current_page' => $page,
                'per_page' => $limit,
                'total_pages' => ceil($total / $limit),
            ],
            'timestamp' => $configData,
        ];
    }

 
    http_response_code(200);
    echo json_encode($response);
}else{
    echo json_encode([
        'success' => true,
        'message' => 'Fields are missing.',
        'code' => 200,
        'data' => []
    ]);
}