<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = [];
$product = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$FailStatusCode = 202;
$FailStatusMsg = "Credentials Incorrect!";


$un = $_GET['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];

try{
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
}catch (Exception $e) {
    $response['status'] = $FailStatusCode;
    $response['message'] = "Database con error: " . $e->getMessage();
    
    //http_response_code(500);
    echo json_encode($response);
    exit;
}



    // Input parameters
    $name = isset($_GET['name']) ? $_GET['name'] : null;
    $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $limit = 100;
    $offset = ($page - 1) * $limit;

    // Validate required parameter
    if (!$name) {
        echo json_encode([
            'success' => false,
            'message' => 'Ledger name is required.',
        ]);
        exit;
    }

    // Main query to fetch billing list
    $query = "SELECT 
                trn_accounting.guid, 
                trn_accounting.ledger, 
                trn_accounting.amount, 
                trn_voucher.date, 
                trn_voucher.voucher_type, 
                trn_voucher.voucher_number
              FROM trn_accounting
              INNER JOIN mst_ledger ON trn_accounting.ledger = mst_ledger.name
              INNER JOIN trn_voucher ON trn_accounting.guid = trn_voucher.guid
              WHERE mst_ledger.name = '" . mysqli_real_escape_string($con, $name) . "'
              LIMIT $limit OFFSET $offset";

    $result = mysqli_query($con, $query);

    if (!$result) {
        echo json_encode([
            'success' => false,
            'message' => 'Error executing query.',
            'error' => mysqli_error($con),
        ]);
        exit;
    }

    // Fetch results and calculate outstanding amount
    $billingList = [];
    $outstandingAmount = 0;

    while ($row = mysqli_fetch_assoc($result)) {
        $row['amount'] = (float)$row['amount'];
        $outstandingAmount += $row['amount'];
        $billingList[] = $row;
    }

    // Fetch Config Data
    $configQuery = "SELECT name, value FROM config WHERE name = 'Update Timestamp' LIMIT 1";
    $configResult = mysqli_query($con, $configQuery);
    $configData = mysqli_fetch_assoc($configResult);

    // Prepare response
    echo json_encode([
        'success' => true,
        'data' => $billingList,
        'outstanding' => number_format($outstandingAmount, 3, '.', ''),
        'timestamp' => $configData,
    ]);



 
http_response_code(200);
//echo json_encode($response);
