<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = [];
$data1 = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Data fetch successfully!";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);
$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if (!empty($data["rid"])) {

    $rid = htmlspecialchars(strip_tags($data["rid"]));
    $sql1 = "SELECT * ,t1.empId as emp_id
            FROM 
            `tbl_revisit` t1
            LEFT JOIN 
            `tbl_farmer` t2
            ON 
            t2.`farmerId` = t1.`farmerId` 
            LEFT JOIN
            `tbl_category` t3
            ON 
            t3.`category_id` = t2.`farmerRegion`
            LEFT JOIN 
            `tbl_employee` t4
            ON
            t4.`id` = t1.`empId`
            WHERE 
            rid = '$rid'";

    $query1 = mysqli_query($con, $sql1);
    if ($query1) {
        $count1 = mysqli_num_rows($query1);
    } else {
        die(mysqli_error());
        http_response_code(503);
    }   
    if ($count1 > 0) {
        while ($row = mysqli_fetch_array($query1)) {
            
            $sql11 = "SELECT * FROM `tbl_purpose` WHERE `purpose_id` = '".$row["revisit_purpose_id"]."'";
            $query11 = mysqli_query($con, $sql11);
            $row11 = mysqli_fetch_array($query11);
            
            array_push($data1, [
                "revisitId" => $row["rid"],
				"farmerId" => $row["farmerId"],
				"farmerName" => $row["farmerName"],
				"farmerMobile" => $row["farmerMobile"],
				"farmerLandAcerage" => $row["farmerLandAcerage"],
				"farmerRegionName" => $row["category_name"],
                "revistPurpose" => $row11["purpose_name"],
                "photo" => $row["photo"],
                "revisit_date_time" => $row["revisit_datetime"],
                "revisit_lat_long" => $row["lat_long"],
                "finding" => $row["finding"],
                "suggestion_to_farmer" => $row["suggestion_to_farmer"],
                "suggestion_from_farmer" => $row["suggestion_from_farmer"]
            ]);
        }
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
        $response['details'] = $data1;
    } else {
        http_response_code(400);
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
