<?php

// error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include("functions/getIds.php");
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";


$unauthorisedUserMsg = "Unauthorised access terminated !";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$suListArray = [];

if (!empty($data["empId"]) && !empty($data["eid"]) && !empty($data["page"])) {
    $un = $data['eid'];
    $type = $data["agencyType"];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $productValArry = getAllProductsName('All',$con);

    $empid = $data["empId"];
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;

    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empid' AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $region = $row1["region"];

    $row = getRegionId($con,$region);
    $sql2 = "SELECT * FROM `tbl_employee` WHERE `region` IN ($row) AND `deleteFlag` = 0";
    $query2 = mysqli_query($con, $sql2);
    $count2 = mysqli_num_rows($query2);
    $row2 = '';
    while ($rs1 = mysqli_fetch_array($query2)) {
        $row2 .= $rs1['id'] . ",";
    }
    $row2 = substr($row2, 0, -1);

    $sql = "SELECT t1.*,t2.agencyShopName,t1.activity_time,t3.category_name
            FROM `tbl_stockupdate` t1
            LEFT JOIN tbl_agency t2 ON t2.agencyId = t1.agencyId
            LEFT JOIN `tbl_category` t3 ON t2.agencyRegion = t3.category_id
            WHERE t1.empId IN ($row2)";
        
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t2.agencyShopName LIKE '%$search%' 
                  OR t1.remark LIKE '%$search%' 
                  OR t1.date LIKE '%$search%' )";
    }
    
    $sql .= " ORDER BY t1.id DESC LIMIT $itemsPerPage OFFSET $offset";
    // echo $sql;
    $query11 = mysqli_query($con, $sql);
    $rowCount11 = mysqli_num_rows($query11);
    $actualDataCounter = 0;

    if ($query11) {
        if ($rowCount11 > 0) {
            while ($row = mysqli_fetch_array($query11)) {
                
                array_push(
                    $suListArray,
                    [
                        "rowid" => $row['id'],
                        "agencyName" => $row['agencyShopName'],
                        "agencyType" => $row['agencyType'],
                        "remark" => $row['remark'],
                        "date" => $row['date'],
                        "agencyRegion" => $row['category_name'],
                        "activity_time" => $row['activity_time']
                    ]
                );
            }
            $response['suVisitList'] = $suListArray;
            $response['Count'] = $rowCount11;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['statu'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
