<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = [];
$data1 = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Data fetch successfully!";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);
$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if (!empty($data["tadaId"])) {

    $tadaId = htmlspecialchars(strip_tags($data["tadaId"]));
    $sql1 = "SELECT * ,t1.id as tadaId
            FROM 
            `tbl_tada` t1
            LEFT JOIN
            `tbl_employee` t3 
            ON
            t3.id = t1.uid
            WHERE 
            t1.`id` = '$tadaId'";

    $query1 = mysqli_query($con, $sql1);
    if ($query1) {
        $count1 = mysqli_num_rows($query1);
    } else {
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }   
    if ($count1 > 0) {
        while ($row = mysqli_fetch_array($query1)) {
            $date = $row['tadaDate'];
            $uid = $row['uid'];
            $sqlDayStart = "SELECT * FROM tbl_daystart WHERE date = '$date' AND uid = '$uid'";
            $resultDayStart = mysqli_query($con,$sqlDayStart);
            $rowDayStart = mysqli_fetch_assoc($resultDayStart);
            
            if($row['editableMode'] == 'PRIVATE (4 WHEELER)'){
                $ta = $row['taCar'];
            }else if($row['editableMode'] == 'PRIVATE (2 WHEELER)'){
                $ta = $row['ta'];
            }else{
                $ta = 0;
            }
            $row['ta'] = $row['ta'] = ($row['ta'] == 'NA' || !isset($row['ta']) || $row['ta'] === '') ? 0 : $row['ta'];
            $row['da'] = $row['da'] = ($row['da'] == 'NA' || !isset($row['da']) || $row['da'] === '') ? 0 : $row['da'];
            
            $row['editableExpense'] = isset($row['editableExpense']) && $row['editableExpense'] !== '' ? $row['editableExpense'] : 0;
            $row['editableOtherExpense'] = isset($row['editableOtherExpense']) && $row['editableOtherExpense'] !== '' ? $row['editableOtherExpense'] : 0;
            $row['auto'] = isset($row['auto']) && $row['auto'] !== '' ? $row['auto'] : 0;
            $row['stationery'] = isset($row['stationery']) && $row['stationery'] !== '' ? $row['stationery'] : 0;
            $row['vehmant'] = isset($row['vehmant']) && $row['vehmant'] !== '' ? $row['vehmant'] : 0;
            $row['petrol'] = isset($row['petrol']) && $row['petrol'] !== '' ? $row['petrol'] : 0;
              
            $totalAmount = $row['ta'] + $row['da'] + $row['editableExpense'] + $row['editableOtherExpense'] + $row['auto'] + $row['stationery'] + $row['vehmant'] + $row['petrol'];
                
            
            array_push($data1, array(
                "tadaId" => $row['tadaId'],
                "tadaDate" => $row['tadaDate'],
                "editableForm" => $row['editableForm'],
                "editableTo" => $row['editableTo'],
                "editableDistance" => $row['editableDistance'],
                "editableMode" => $row['editableMode'],
                "etdsg" => $row['etdsg'],
                "editableExpense" => $row['editableExpense'],
                "editableOtherExpense" => $row['editableOtherExpense'],
                "start_image" => $row['start_image'],
                // "end_image" => $row['end_image'],
                "status" => $row['status'],
                "empName" => $row['emp_name'],
                "ta" => $ta,
                "da" => $row['da'],
                "bill_img" => $row['bill_img'],
                "remark" => $row['remark'],
                "auto" => $row['auto'],
                "stationery" => $row['stationery'],
                "isApproved" => $row['isApproved'],
                "vehmant" => $row['vehmant'],
                "petrol" => $row['petrol'],
                "tada_pdf" => $row['tada_pdf'],
                "openingReading" => $rowDayStart['sdis'],
                "closingReading" => $rowDayStart['edis'],
                "totalAmount" => $totalAmount
               
            ));
        }
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
        $response['details'] = $data1;
    } else {
        // http_response_code(400);
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
