<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include_once 'functions/getIds.php'; 

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated! Sync required";
$updateNotMsg = "You are updated! Sync not required";

$unauthorisedUserMsg = "Unauthorized access terminated!";
$data = json_decode(file_get_contents("php://input"), true);

$response = [];
$Testiarray = [];


$un = $data['eid'];
$un1 = (explode("-", $un));
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

if (!empty($data["empId"]) && !empty($data["page"])) {
    $empid = $data["empId"];
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    $sql1 = "SELECT * FROM `tbl_employee` WHERE `id` = '$empid' AND `deleteFlag` = 0";
    $query1 = mysqli_query($con, $sql1);
    $row1 = mysqli_fetch_array($query1);
    $desig = $row1["empDesignation"];
    $region = $row1["region"];

    $rid = getRegionId($con,$region);

    $sql = "SELECT t1.*, t4.testimonial_type_name,
                CASE 
                    WHEN t1.testCustTypeId = '1' THEN t2.farmerName
                    WHEN t1.testCustTypeId IN ('2', '3') THEN t3.agencyShopName
                END AS customerName,
                CASE 
                    WHEN t1.testCustTypeId = '1' THEN t2.farmerMobile
                    WHEN t1.testCustTypeId IN ('2', '3') THEN t3.agencyMobile
                END AS customerMobile
                FROM `tbl_testimonial` t1
                LEFT JOIN `tbl_farmer` t2 ON t1.customerId = t2.farmerId AND t1.testCustTypeId = '1'
                LEFT JOIN `tbl_agency` t3 ON t1.customerId = t3.agencyId AND t1.testCustTypeId IN ('2', '3')
                LEFT JOIN `tbl_testimonial_type` t4 ON `testimonial_type_id`= testMeetingTypeId
                WHERE t1.regionId IN ($rid)";
    //  search filter
    $search = isset($data['search']) ? $data['search'] : '';
    if(isset($data['search'])){
        $sql .= " AND ( t3.agencyShopName LIKE '%$search%' 
                  OR t3.agencyMobile LIKE '%$search%' 
                  OR t2.farmerName LIKE '%$search%' 
                  OR t2.farmerMobile LIKE '%$search%' 
                  OR t4.testimonial_type_name LIKE '%$search%' 
                  OR t1.testDate LIKE '%$search%')";
    }
    
    $sql .= " ORDER BY t1.testDate DESC LIMIT $itemsPerPage OFFSET $offset";
    // echo $sql;
    $query = mysqli_query($con, $sql);
    $rowCount = mysqli_num_rows($query);
    
    if ($query) {
        if ($rowCount > 0) {
            while ($row = mysqli_fetch_array($query)) {
                    array_push($Testiarray, array(
                        "rowid" => $row['testId'],
                        "type" => $row['testimonial_type_name'],
                        "cropId" => $row['cropId'],
                        "productId" => $row['productId'],
                        "customerId" => $row['customerId'],
                        "customerName" => $row['customerName'],
                        "customermobile" => $row['customerMobile'],
                        "datofSowing" => $row['datofSowing'],
                        "dateOfSpray" => $row['dateOfSpray'],
                        "empId" => $row['empId'],
                        "testPhoto" => $row['testPhoto'],
                        "testVdo" => $row['testVdo'],
                        "testMeetingTypeId" => $row['testMeetingTypeId'],
                        "testCustTypeId" => $row['testCustTypeId'],
                        "accompainedBy" => $row['accompainedBy'],
                        "testRemark" => $row['testRemark'],
                        "regionId" => $row['regionId'],
                        "date" => $row['testDate'],
                        "activity_time" => $row['activity_time']
                    ));
            }
            $response['testolist'] = $Testiarray;
            $response['Count'] = $rowCount;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['code'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
