<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
$response = [];
$data1 = [];
$agency = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Agency registered successfully!";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorized access terminated!";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["agencyRegion"]) && !empty($data["empId"])) {
    $un = $data['eid'];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

    $agencyRegion = htmlspecialchars(strip_tags($data["agencyRegion"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $agencyType = htmlspecialchars(strip_tags($data["agencyType"]));

    $count = 1;
    if ($count > 0) {
        $sql = "select  category_id,
                category_name,
                parent_category_id
                from (select * from tbl_category
                order by parent_category_id, category_id) tbl_category,
                (select @pv := " . $agencyRegion . ") initialisation
                where find_in_set(parent_category_id, @pv) > 0
                and @pv := concat(@pv, ',', category_id)";
        $row = $agencyRegion;
        $query = mysqli_query($con, $sql);
        $count = mysqli_num_rows($query);
        if ($count > 0) {
            while ($rs = mysqli_fetch_array($query)) {
                $row = $row . "," . $rs['category_id'];
            }
        }

        $sql1 = "SELECT * FROM `tbl_agencyvisit` LEFT JOIN `tbl_agency` ON 
                tbl_agencyvisit.agencyId = tbl_agency.agencyId WHERE 
                `tbl_agencyvisit`.agencyRegion IN ($row) AND `tbl_agencyvisit`.agencyType = '$agencyType'";

        $query1 = mysqli_query($con, $sql1);
        if ($query1) {
            $count1 = mysqli_num_rows($query1);
        } else {
            die(mysqli_error());
            http_response_code(503);
        }

        if ($count1 > 0) {
            while ($row = mysqli_fetch_array($query1)) {
                array_push($data1, [
                    "visitId" => $row["visitId"],
                    "visitDate" => $row["visitDate"],
                    "agencyId" => $row["agencyId"],
                    "agencyName" => $row["agencyName"],
                    "agencyMobile" => $row["agencyMobile"],
                    "agencyCity" => $row["agencyCity"],
                    "cropUpdate" => $row["cropUpdate"],
                    "liquidation" => $row["liquidation"],
                    "feedback" => $row["feedback"],
                    "collecttion" => $row["collecttion"],
                    "postHarvest" => $row["postHarvest"],
                    "accompanedBy" => $row["accompanedBy"],
                    "empId" => $row["empId"],
                    "latlong" => $row["latlong"],
                    "agencyRegion" => $row["agencyRegion"]
                ]);
                $agency[] = $data1;
            }
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
            $response['detail'] = $data1;
            http_response_code(200);
        } else {
            http_response_code(400);
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
    } else {
        http_response_code(400);
        $response['status'] = $unauthorisedUserCode;
        $response['message'] = $unauthorisedUserMsg;
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
