 <?php

error_reporting(0);

// Set headers for CORS and JSON
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once '../db_config/config1.php';

$response = [];

$data = json_decode(file_get_contents("php://input"), true);

// Validate required parameters
if (!empty($data["eid"]) && !empty($data["empId"])) {
    $eid = $data['eid'];
    $emp_id = $data['empId'];
    $un1 = explode("-", $eid);
    $client_db = $base_dbname . $un1[0];

    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $client_db);
    if ($con->connect_error) {
        echo json_encode(['error' => true, 'message' => 'DB connection failed']);
        exit;
    }

    // Set financial year range
    $currentDate = date('Y-m-d');
    $currentYear = date('Y', strtotime($currentDate));
    if($un1[0] == 'frts'){
        $fyStart = $currentYear . '-01-01';
        $fyEnd = $currentYear . '-12-31';
    }else{
        if (date('n', strtotime($currentDate)) < 4) {
            $fyStart = ($currentYear - 1) . '-04-01';
            $fyEnd = $currentYear . '-03-31';
        } else {
            $fyStart = $currentYear . '-04-01';
            $fyEnd = ($currentYear + 1) . '-03-31';
        }
    }
    // Get employee's designation and allotment type
    $empQuery = "SELECT empDesignation, leave_allotment_type FROM tbl_employee WHERE id = '$emp_id'";
    $empResult = $con->query($empQuery);
    $empData = $empResult->fetch_assoc();
    $designationId = $empData['empDesignation'];
    $allotmentType = $empData['leave_allotment_type'];

    // Build allotment join
    if ($allotmentType == 2) {
        $allotmentJoin = "
            LEFT JOIN (
                SELECT leaveType, SUM(leaveCount) AS allotted
                FROM tbl_emp_allotted_leave
                WHERE emp_id = '$emp_id'
                  AND isDeleted = 0
                  AND add_to_table = 1
                GROUP BY leaveType
            ) AS allot ON t2.id = allot.leaveType
        ";
    } else {
        $allotmentJoin = "
            LEFT JOIN (
                SELECT leaveType, SUM(leaveCount) AS allotted
                FROM tbl_designation_wise_leave
                WHERE designationId = '$designationId'
                  AND isDeleted = 0
                  AND add_to_table = 1
                GROUP BY leaveType
            ) AS allot ON t2.id = allot.leaveType
        ";
    }

    // Final merged query
    $leaveSql = "
        SELECT 
            t2.id AS leaveTypeId,
            t2.leavetype,
            COALESCE(SUM(t1.total_days), 0) AS leavesTaken,
            COALESCE(allot.allotted, 0) AS leavesAllotted
        FROM tbl_leavetype t2
        LEFT JOIN tbl_leave_application t1 
            ON t1.leave_type_id = t2.id 
            AND t1.emp_id = '$emp_id'
            AND t1.isApproved = 1
            AND t1.leave_status = 1
            AND t1.leave_from BETWEEN '$fyStart' AND '$fyEnd'
        $allotmentJoin
        GROUP BY t2.id, t2.leavetype
        ORDER BY t2.id
    ";

    $leaveResult = $con->query($leaveSql);

    $leaveSummary = [];
    $totalTaken = $totalAllotted = $totalRemaining = 0;

    if ($leaveResult && $leaveResult->num_rows > 0) {
        while ($row = $leaveResult->fetch_assoc()) {
            $taken = floatval($row['leavesTaken']);
            $allotted = floatval($row['leavesAllotted']);
            
            if($allotted > 0){
                $remaining = round($allotted - $taken, 2);
    
                $leaveSummary[] = [
                    'leaveTypeId'      => $row['leaveTypeId'],
                    'leavetype'        => $row['leavetype'],
                    'leavesTaken'      => $taken,
                    'leavesAllotted'   => $allotted,
                    'leavesRemaining'  => $remaining
                ];
    
                $totalTaken     += $taken;
                $totalAllotted  += $allotted;
                $totalRemaining += $remaining;
            }
        }
    }

    // Get LWP (Leave Without Pay)
    $lwpSql = "
        SELECT SUM(
            CASE 
                WHEN leave_duration IN (1,2,3) THEN CAST(total_days AS DECIMAL(5,2))
                ELSE 0
            END
        ) AS lwp
        FROM tbl_leave_application
        WHERE emp_id = '$emp_id' 
          AND (isApproved != 1 OR leave_status != 1)
          AND leave_from BETWEEN '$fyStart' AND '$fyEnd'
    ";
    $lwpResult = $con->query($lwpSql);
    $lwp = ($lwpResult && $lwpRow = $lwpResult->fetch_assoc()) ? floatval($lwpRow['lwp']) : 0;

    $response = [
        'error' => false,
        'message' => 'Leave summary fetched successfully',
        'data' => $leaveSummary,
        'totals' => [
            'totalLeavesAllotted'    => round($totalAllotted, 2),
            'totalLeavesTaken'       => round($totalTaken, 2),
            'totalLeavesRemaining'   => round($totalRemaining, 2),
            'totalLeavesWithoutPay'  => round($lwp, 2)
        ]
    ];

    $con->close();
} else {
    $response = ['error' => true, 'message' => 'Required parameters eid and empId are missing'];
}

echo json_encode($response, JSON_PRETTY_PRINT);
exit;
?>