<?php
//error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = [];
$data1 = [];

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Data fetch successfully!";

$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found!";

$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong! Unable to send you the list.";

$unauthorisedUserCode = 203;
$unauthorisedUserMsg = "Unauthorised access terminated!";

$data = json_decode(file_get_contents("php://input"), true);
$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
function fetchBalanceLeave($startFinancialYear,$endDate,$designationId){
    global $con;
    global $uid;
    $query = "SELECT IFNULL(SUM(leaveCount), 0) as totalLeave FROM `tbl_designation_wise_leave` WHERE designationId = '$designationId'";
    $result = $con->query($query);
    // print_r($result);
    $data = $result->fetch_object();
    $totalLeaves = $data->totalLeave;
    
    return $totalLeaves;
}

function countSundaysBetweenDates($fromDate, $toDate) {
    $start = new DateTime($fromDate);
    $end = new DateTime($toDate);
    $interval = new DateInterval('P1D'); // 1 day interval

    $period = new DatePeriod($start, $interval, $end);
    foreach ($period as $date) {
        if ($date->format('l') === 'Sunday') {
            $sunday[] = $date->format('Y-m-d');
        }
    }
    return $sunday;
}

function getLeavesData($year,$month,$region,$empId){
    global $con;
    $currentYear = $year; 
    if ($month < 4) {
        $startFinancialYear = ($currentYear - 1) . '-04-01';
        $endFinancialYear = $currentYear . '-03-31';
    } else {
        $startFinancialYear = $currentYear . '-04-01';
        $endFinancialYear = ($currentYear + 1) . '-03-31';
    }
    
    
    $fromDate  = date($year.'-'.$month.'-01');
    $toDate = date($year.'-'.$month.'-31');
    
    $dateTime1 = new DateTime($fromDate);
    $dateTime2 = new DateTime($toDate);
    $interval = $dateTime1->diff($dateTime2);
    
    $totalDays = $interval->days+1;
    $currentMonth15 = date('Y-m-15'); 
    $fromDateObj = new DateTime($fromDate);
    
    
    // $totalDays;
    $weekOffDate = countSundaysBetweenDates($fromDate, $toDate);
    $totalSundays = count($weekOffDate);
    // $totalWorkingDay = $totalDays-$totalHoliday;
    $inputCategoryId = $region;
    
    if ($inputCategoryId == 1) {
        $unitId = 1;
    } else {
        // Execute the query using prepared statements
        $sql1 = "SELECT FindImportantCategory($inputCategoryId) as unitName";
        $result1 = mysqli_query($con,$sql1);
        $unitResult = mysqli_fetch_assoc($result1);
    
        // Access the result
        $unitName = $unitResult['unitName'];
    
        $stmt = "SELECT * FROM tbl_category WHERE category_name = '$unitName'";
        $categoryResult = mysqli_query($con,$stmt);
        $category = mysqli_fetch_assoc($categoryResult);
        if ($category) {
            $unitId = $category['category_id'];
        } else {
            $unitId = '';
        }
    }
    
    
    $datewiseActivity = array();
    if ($unitId == 1) {
        $holidayDateArray = "SELECT count(*) as totalHoliday 
                             FROM 
                                tbl_holydaycalender 
                             WHERE 
                                `date` BETWEEN '$fromDate' AND '$toDate'
                             AND 
                                `isDeleted` = '0'";
    } else {
        $holidayDateArray = "SELECT count(*) as totalHoliday 
                             FROM 
                                tbl_holydaycalender 
                             WHERE 
                                `date` BETWEEN '$fromDate' AND '$toDate'
                             AND 
                                `region` = '$unitId'
                             AND 
                                `isDeleted` = '0'"; 
    }
    
    $holidayResult = mysqli_query($con,$holidayDateArray);
    $holiday = mysqli_fetch_assoc($holidayResult);
    if ($holiday) {
        $holidayCount = $holiday['totalHoliday'];
    } else {
        $holidayCount = '0';
    }
    $totalDays;
    $totalHoliday = $totalSundays+$holidayCount;
    $totalWorkingDay = $totalDays-$totalHoliday;
    
    $query1 = "SELECT count(*) as totCount FROM tbl_daystart where `uid`= '$empId' AND `date` BETWEEN '$fromDate' AND '$toDate' "; 
    $result1 = mysqli_query($con,$query1);
    $rowCount = mysqli_num_rows($result1);
    while ($data = mysqli_fetch_assoc($result1)) {
        $paidDays = $data['totCount'];
    }
    
    $query1 = "SELECT count(*) as totLCount FROM tbl_leave_application_details where `emp_id`= '$empId' AND `leave_date` BETWEEN '$fromDate' AND '$toDate' "; 
    $result1 = mysqli_query($con,$query1);
    $rowCount = mysqli_num_rows($result1);
    
    while ($data = mysqli_fetch_assoc($result1)) {
        $leavesTake = $data['totLCount'];
    }
    
    
    $payment = array();
    $absentDays = $totalWorkingDay - ($paidDays+$leavesTake);
    //fetch lwp
    $edate = date('Y-m-d', strtotime('-1 month', strtotime($toDate))); 
    $endDate  = date('Y-m-d', strtotime('-1 day', strtotime($edate)));
    
    $query1 = "SELECT count(*) as totalTakenLeaves FROM `tbl_leave_application_details` WHERE emp_id = '$empId' AND leave_date BETWEEN '$startFinancialYear' AND '$endDate'";
    $result1 = $con->query($query1);
    $data1 = $result1->fetch_object();
    $totalTakenLeaves = $data1->totalTakenLeaves;
    // echo $totalLeaves;
    if($totalTakenLeaves >= $totalLeaves){
        // echo 'if';
        $totalBalanceLeave = 0;
    }else{
        // echo 'else';
        $totalBalanceLeave = $totalLeaves - $totalTakenLeaves;
    }
    
    $totalDays = cal_days_in_month(CAL_GREGORIAN,$month,$year);
    $perDayCost = $grossSalary/$totalDays;
    
    if($totalBalanceLeave==0){
        $allLeaves = $totalWorkingDay-$paidDays;
        $totalLWPAmount = $allLeaves*$perDayCost;
        $paidLeaves = 0;
        $lwp = 0;
    }else{
        $query2 = "SELECT count(*) as totalTakenLeavesCurMonth FROM `tbl_leave_application_details` WHERE emp_id = '$empId' AND leave_date BETWEEN '$fromDate' AND '$toDate'";
        $result2 = $con->query($query2);
        $data2 = $result2->fetch_object();
        $totalTakenLeaves = $data1->totalTakenLeavesCurMonth;
        if($totalBalanceLeave > $totalTakenLeaves){
            $totalLWPAmount = $absentDays*$perDayCost;
            $lwp = $absentDays;
            $paidLeaves = $leavesTake;
        }else{
            $lwp = ($totalTakenLeaves-$totalBalanceLeave)+$absentDays;
            $totalLWPAmount = $lwp*$perDayCost;
            $paidLeaves = $totalTakenLeaves-$totalBalanceLeave;
        }
    }
    $finalDeduction = $deduction+$totalLWPAmount;
    
    
        $payment = [
            'monthName' => date('F Y',strtotime($fromDate)),
            'workingDays' => $totalWorkingDay,
            'LWP' => $lwp,
            'PaidLeaves' => $paidLeaves,
            'presentDays' => $paidDays,
            'absentDays' => $totalWorkingDay-$paidDays,
            'balanceLeave' => $totalBalanceLeave
        ];
    return json_encode($payment);
}

if (!empty($data["empId"]) && !empty($data["year"]) && !empty($data["month"])) {
    
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $year = htmlspecialchars(strip_tags($data["year"]));
    $month = htmlspecialchars(strip_tags($data["month"]));
    
    $query1 = "SELECT * FROM `tbl_companyinfo`";
    $result1 = $con->query($query1);
    $data11 = $result1->fetch_object();

    if ($data11 !== null && strlen($data11->company_name) > 0) {
        $cname = $data11->company_name;
    } else {
        $cname = "na";
    }

    if ($data11 !== null && strlen($data11->c_img) > 0) {
        $c_img = $data11->c_img;
    } else {
        $c_img = "";
    }
    
    $sql1 = "SELECT * 
            FROM 
            `tbl_salary_generate` t1
            LEFT JOIN
            `tbl_employee` t3 
            ON
            t3.id = t1.empId
            WHERE 
            t1.`year` = '$year' AND month = '$month' AND empId = '$empId' AND mobileActivateFlag = 1";

    $query1 = mysqli_query($con, $sql1);
    if ($query1) {
        $count1 = mysqli_num_rows($query1);
    } else {
        die(mysqli_error());
        http_response_code(503);
    }
    $dateObj   = DateTime::createFromFormat('!m', $month);
    $monthName = $dateObj->format('F'); // March
    if ($count1 > 0) {
        while ($row = mysqli_fetch_array($query1)) {
            $salaryData = json_decode($row['salaryDetail'], true);
            $leaveArray = getLeavesData($year,$month,$row['region'],$empId);
            $earningsCount = count($salaryData['earnings']);
            $deductionsCount = count($salaryData['deductions']);
            
            // Add the counts to the data array
            $salaryData['earnings_row_count'] = $earningsCount;
            $salaryData['deductions_row_count'] = $deductionsCount;
            $salaryData['leaveDetails'] = json_decode($leaveArray);
            
            // Encode the modified data back to JSON
            $modifiedSalaryJsonData = json_encode($salaryData, JSON_PRETTY_PRINT);
            
            array_push($data1, array(
                'company_name' => $cname,
                'company_logo' => "http://" . $_SERVER['SERVER_NAME'] . "/images/company_img/".$c_img,
                "empId" => $row['empId'],
                "Month" => $monthName.' '.$year,
                "Month" => $monthName.' '.$year,
                "salaryDetails" => json_decode($modifiedSalaryJsonData),
                //"leaveDetails" => $leaveArray,
            ));
        }
        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
        $response['details'] = $data1;
    } else {
        // http_response_code(400);
        $response['status'] = $noDataFoundcode;
        $response['message'] = $noDataFoundMsg;
    }
} else {
    $response['status'] = $unauthorisedUserCode;
    $response['message'] = $unauthorisedUserMsg;
}
echo json_encode($response);
