<?php
header("Content-Type: application/json");
require_once '../db_config/config1.php';
require_once '../db_config/configmulti.php';

$response = [];

if (!isset($_POST['eid']) || !isset($_POST['month']) || !isset($_POST['year']) || !isset($_POST['id'])) {
    echo json_encode([
        "error" => true,
        "message" => "Missing parameters (eid, month, year, id)"
    ]);
    exit;
}

$eid = $_POST['eid'];
$month = (int)$_POST['month'];
$year = (int)$_POST['year'];
$id = (int)$_POST['id'];

$un1 = explode("-", $eid);
$client_db = $base_dbname . $un1[0];

$mysql = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $client_db);
if ($mysql->connect_error) {
    echo json_encode(["error" => true, "message" => "DB Connection Failed"]);
    exit;
}

// Fetch region
$regionQuery = $mysql->query("SELECT region FROM tbl_employee WHERE id = '$id' LIMIT 1");
$region = ($regionQuery->num_rows > 0) ? $regionQuery->fetch_assoc()['region'] : '0';

$today = date("Y-m-d");
$daysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year);
$attendance = [];
$present_days = $absent_days = $weekly_offs = $holidays = $leaves = $half_days = 0;

for ($d = 1; $d <= $daysInMonth; $d++) {
    $date = date("Y-m-d", strtotime("$year-$month-$d"));
    if ($date > $today) break;

    $weekday = date('w', strtotime($date));
    $isSunday = ($weekday == 0);
    
    $entry = [
        "date" => $date,
        "stime" => null,
        "etime" => null,
        "delayFlag" => null,
        "working_day" => "Yes",
        "status" => "Absent",
        "leave" => "LWP"
    ];

    // Weekly Off
    if ($isSunday) {
        $entry["working_day"] = 'No';
        $entry["status"] = "Weekly Off";
        $weekly_offs++;
    }

    // Holiday
    //echo "SELECT holiday_name FROM tbl_holydaycalender WHERE region = '$region' AND date = '$date'";
    //exit;

    $holidayQuery = $mysql->query("SELECT holiday_name FROM tbl_holydaycalender WHERE region = '$region' AND date = '$date'");
    if ($holidayQuery->num_rows > 0) {
        $holiday = $holidayQuery->fetch_assoc();
        $entry["working_day"] = 'No';
        $entry["status"] = "Holiday";
        $entry["holiday_title"] = $holiday['holiday_name'];
        $holidays++;
    }
    // Attendance
    $stmt = $mysql->prepare("SELECT stime, etime, delayFlag FROM tbl_daystart WHERE uid = ? AND date = ?");
    $stmt->bind_param("is", $id, $date);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        $entry['stime'] = $row['stime'];
        $entry['etime'] = $row['etime'];
        $entry['delayFlag'] = $row['delayFlag'];
        if($row['delayFlag'] == 9){
            $entry['status'] = 'Absent - short working hours';
            $absent++;
        }elseif (in_array($row['delayFlag'], [2, 3, 4, 5, 6])) {
            $entry['status'] = 'Half Day';
            $half_days++;
        }else{
            $entry['status'] = 'Present';
            $present_days++;
        }
        
    } else {
        // Check Leave
        $stmt = $mysql->prepare("SELECT l.leave_type_id, l.leave_duration, t.leavetype, l.isApproved 
                                 FROM tbl_leave_application_details d
                                 JOIN tbl_leave_application l ON l.leave_id = d.leave_id
                                 LEFT JOIN tbl_leavetype t ON t.id = l.leave_type_id
                                 WHERE d.emp_id = ? AND d.leave_date = ? AND l.isApproved = 1");
        $stmt->bind_param("is", $id, $date);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res->num_rows > 0) {
            $row = $res->fetch_assoc();
            $entry['status'] = 'On Leave';
            $entry['leave'] = [
                "type" => $row['leavetype'],
                "duration" => $row['leave_duration'] // 1=Full, 2=Half S1, 3=Half S2
            ];
            $leaves++;
            if ($row['leave_duration'] != 1) $half_days++;
        }
    }

    // Finalize absent count
    if ($entry["status"] == "Absent") {
        $absent_days++;
    }

    $attendance[] = $entry;
}

$working_days = count($attendance) - $weekly_offs - $holidays;

$response = [
    "error" => false,
    "employee_id" => $id,
    "month" => "$year-$month",
    "summary" => [
        "total_days" => $daysInMonth,
        "till_today" => count($attendance),
        "working_days" => $working_days,
        "present_days" => $present_days,
        "absent_days" => $absent_days,
        "weekly_offs" => $weekly_offs,
        "holidays" => $holidays,
        "leaves" => $leaves,
        "half_days" => $half_days
    ],
    "attendance" => $attendance
];

echo json_encode($response);
?>
