<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/getIds.php';

$response = array();
$myTeamActivityTarget = array();
$myTeamActivityTargetAchieve = array();

$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful!";
$FailStatusCode = 202;
$FailStatusMsg = "Credentials Incorrect!";

$data = json_decode(file_get_contents("php://input"), true);

$un = $data['eid'];
$un1 = explode("-", $un);
$un2 = $base_dbname . $un1[0];
$con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

$empId = $data['empId'];
$regionId = $data['regionId'];
$getAllEmpIds = getEmployeeId($con,$regionId);
$fromDate  = date('Y-m-01');
$toDate = date('Y-m-d', strtotime('last day of +0 month'));

$sql = "SELECT 
            SUM(icTarget) AS icTargetVal,
            SUM(sdTarget) AS sdTargetVal,
            SUM(fdTarget) AS fdTargetVal,
            SUM(organisedMeetingTarget) AS organisedMeetingTargetVal,
            SUM(groupMeetingTarget) AS groupMeetingTargetVal,
            SUM(avTarget) AS avTargetVal,
            SUM(revisit) AS revisitTargetVal,
            SUM(paymentSum) AS paymentTargetVal,
            SUM(`orderSum`) AS orderTargetVal
        FROM 
            `tbl_activity_target` 
        WHERE 
            `empId` IN ($getAllEmpIds) 
        AND 
            `date_from` = '$fromDate' 
        AND 
            `date_to` = '$toDate'";
$query = mysqli_query($con, $sql);

while ($row = mysqli_fetch_array($query)) {
    array_push($myTeamActivityTarget, array(
        "ic" => $row['icTargetVal'],
        "sd" => $row['sdTargetVal'],
        "fd" => $row['fdTargetVal'],
        "fm" => $row['organisedMeetingTargetVal']+$row['groupMeetingTargetVal'],
        "organisedMeetingTarget" => $row['organisedMeetingTargetVal'],
        "groupMeetingTarget" => $row['groupMeetingTargetVal'],
        "revisit" => $row['revisitTargetVal'],
        "av" => $row['avTargetVal'],
        "paymentSum" => $row['paymentTargetVal'],
        "orderSum" => $row['orderTargetVal']
    ));
}

$sqlAchieve = "SELECT
            SUM(tat.ic) AS ic_achieved,
            SUM(tat.revisit) AS revisit_achieved,
            SUM(tat.sd) AS sd_achieved,
            SUM(tat.fd) AS fd_achieved,
            SUM(tat.fm) AS fm_achieved,
            SUM(tat.ofm) AS ofm_achieved,
            SUM(tat.gfm) AS gfm_achieved,
            SUM(tat.av) AS av_achieved,
            SUM(tat.`order`) AS order_achieved,
            SUM(tat.payment) AS payment_achieved
        FROM 
            `tbl_activity_count_current_year` AS tat
        WHERE 
            tat.activityDate BETWEEN '$fromDate' AND '$toDate'
        AND 
            `empId` IN ($getAllEmpIds)  ";
$queryAchieve = mysqli_query($con, $sqlAchieve);
// print_r($queryAchieve);
while ($row = mysqli_fetch_array($queryAchieve)) {
    array_push($myTeamActivityTargetAchieve, array(
        "ic" => $row['ic_achieved'],
        "sd" => $row['sd_achieved'],
        "fd" => $row['fd_achieved'],
        "fm" => $row['fm_achieved'],
        "organisedMeetingTarget" => $row['ofm_achieved'],
        "groupMeetingTarget" => $row['gfm_achieved'],
        "revisit" => $row['revisit_achieved'],
        "av" => $row['av_achieved'],
        "order" => $row['order_achieved'],
        "payment" => $row['payment_achieved']
    ));
}

$response['status'] = $SuccessStatusCode;
$response['message'] = $SuccessStatusMsg;
$response['activityCardTitle'] = date('d M Y', strtotime($fromDate)).' - '.date('d M Y', strtotime($toDate));
$response['myTeamActivityTarget'] = $myTeamActivityTarget;
$response['myTeamActivityTargetAchieve'] = $myTeamActivityTargetAchieve;

http_response_code(200);
echo json_encode($response);
?>
