<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';

$response = [];
$data = [];
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Activity saved successfully!";
$AlreadyStatusCode = 201;
$AlreadyStatusMsg = "Activity already registered!";
$FailStatusCode = 202;
$FailStatusMsg = "Unable to register!";

$data = json_decode(file_get_contents("php://input"), true);

if (!empty($data["agencyId"]) && !empty($data["empId"])) {
    $un = $data['eid'];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);

    $visitDate = htmlspecialchars(strip_tags($data["visitDate"]));
    $agencyId = htmlspecialchars(strip_tags($data["agencyId"]));
    $cropUpdate = htmlspecialchars(strip_tags($data["cropUpdate"]));
    $liquidation = htmlspecialchars(strip_tags($data["liquidation"]));
    $feedback = htmlspecialchars(strip_tags($data["feedback"]));
    $collecttion = htmlspecialchars(strip_tags($data["collecttion"]));
    $postHarvest = htmlspecialchars(strip_tags($data["postHarvest"]));
    $accompanedBy = htmlspecialchars(strip_tags($data["accompanedBy"]));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $latlong = htmlspecialchars(strip_tags($data["latlong"]));
    $agencyRegion = htmlspecialchars(strip_tags($data["agencyRegion"]));
    $Hvalue = htmlspecialchars(strip_tags($data["hvalue"]));
    $agencyType = htmlspecialchars(strip_tags($data["agencyType"]));
    $NoSeasonPass = htmlspecialchars(strip_tags($data["noseasonpass"]));
    $Remark = htmlspecialchars(strip_tags($data["CropRemark"]));
    $PostRemark = htmlspecialchars(strip_tags($data["harvestRemark"]));
    $activity_time = htmlspecialchars(strip_tags($data["activity_time"]));

    $sql = "INSERT INTO `tbl_agencyvisit` (
                `visitDate`, `empId`, `agencyId`, `agencyRegion`, 
                `cropUpdate`, `liquidation`, `feedback`, `collecttion`, 
                `postHarvest`, `accompaniedBy`, `latlong`, `agencyType`,`activity_time`
            ) VALUES (
                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?
            )";
    $stmt = $con->prepare($sql);
    $stmt->bind_param(
                "ssssssssssss", $visitDate, $empId, $agencyId, $agencyRegion, 
                $cropUpdate, $liquidation, $feedback, $collecttion, 
                $postHarvest, $accompaniedBy, $latlong, $agencyType,$activity_time
            );
    $query = $stmt->execute();

    if ($query) {
        $visitId = $stmt->insert_id;
        
        $activityLatLong = str_replace("#","/",$latlong);
        $activityGeotagVal = '#'.$activityLatLong.'/'.$activity_time.'/6/'.$visitId; 
        
		$sql1 = "UPDATE tbl_track 
		         SET 
		        `activityGeotag` = CONCAT(`activityGeotag`, '$activityGeotagVal') 
		         WHERE 
		         eid = '$un' 
		         AND 
		         `date` = '$visitDate'";
        $result1 = mysqli_query($con,$sql1);
        
        if ($cropUpdate == '1') {
            $cropId = htmlspecialchars(strip_tags($data["cropId"]));
            $focusSegment = htmlspecialchars(strip_tags($data["focusSegment"]));
            $sql1 = "INSERT INTO `tbl_cropupdate`(`visitId`, `cropId`, `focusSegment`, `seasonpass`, `remark`) VALUES (?, ?, ?, ?, ?)";
            $stmt1 = $con->prepare($sql1);
            $stmt1->bind_param("sssss", $visitId, $cropId, $focusSegment, $NoSeasonPass, $Remark);
            $query1 = $stmt1->execute();
        }

        if ($liquidation == '1') {
            $herbicideIds = htmlspecialchars(strip_tags($data["herbicideIds"]));
            $herbicideSupply = htmlspecialchars(strip_tags($data["herbicideSupply"]));
            $herbicideStock = htmlspecialchars(strip_tags($data["herbicideStock"]));
            $insecticideIds = htmlspecialchars(strip_tags($data["insecticideIds"]));
            $insecticideSupply = htmlspecialchars(strip_tags($data["insecticideSupply"]));
            $insecticideStock = htmlspecialchars(strip_tags($data["insecticideStock"]));
            $fungicideIds = htmlspecialchars(strip_tags($data["fungicideIds"]));
            $fungicideSupply = htmlspecialchars(strip_tags($data["fungicideSupply"]));
            $fungicideStock = htmlspecialchars(strip_tags($data["fungicideStock"]));
            $pgrIds = htmlspecialchars(strip_tags($data["pgrIds"]));
            $pgrSupply = htmlspecialchars(strip_tags($data["pgrSupply"]));
            $pgrStock = htmlspecialchars(strip_tags($data["pgrStock"]));
            $PNIds = htmlspecialchars(strip_tags($data["pnIds"]));
            $PNSupply = htmlspecialchars(strip_tags($data["pnSupply"]));
            $PNStock = htmlspecialchars(strip_tags($data["pnStock"]));

            $sql2 = "INSERT INTO `tbl_liquidation`(`visitId`, `herbicideIds`, `herbicideSupply`, `herbicideStock`, `insecticideIds`, `insecticideSupply`, `insecticideStock`, `fungicideIds`, `fungicideSupply`, `fungicideStock`, `pgrIds`, `pgrSupply`, `pgrStock`, `hvalue`, `pnIds`, `pnStocks`, `pnSupply`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt2 = $con->prepare($sql2);
            $stmt2->bind_param("sssssssssssssssss", $visitId, $herbicideIds, $herbicideSupply, $herbicideStock, $insecticideIds, $insecticideSupply, $insecticideStock, $fungicideIds, $fungicideSupply, $fungicideStock, $pgrIds, $pgrSupply, $pgrStock, $Hvalue, $PNIds, $PNStock, $PNSupply);
            $query2 = $stmt2->execute();
        }

        if ($feedback == '1') {
            $fdText = htmlspecialchars(strip_tags($data["fdText"]));
            $fdphoto_key = htmlspecialchars(strip_tags($data["fdphoto_key"]));
            $fdDoc = htmlspecialchars(strip_tags($data["fdDoc"]));
            $fdVideo = htmlspecialchars(strip_tags($data["fdVideo"]));
            $sql3 = "INSERT INTO `tbl_feedback`(`visitId`, `fdText`, `fdphoto`, `fdDoc`, `fdVideo`) VALUES (?, ?, ?, ?, ?)";
            $stmt3 = $con->prepare($sql3);
            $stmt3->bind_param("sssss", $visitId, $fdText, $fdphoto_key, $fdDoc, $fdVideo);
            $query3 = $stmt3->execute();
        }

        if ($postHarvest == '1') {
            $sql4 = "INSERT INTO `tbl_postharvest`(`visitId`, `remark`) VALUES (?, ?)";
            $stmt4 = $con->prepare($sql4);
            $stmt4->bind_param("ss", $visitId, $PostRemark);
            $query4 = $stmt4->execute();
        }

        if ($agencyType == '1') {
            $sqlUpdateKey = "UPDATE `tbl_updatekeynew` SET `agenyVisitList` = agenyVisitList + 1 WHERE `id` = 1";
            $queryUpdateKey = mysqli_query($con, $sqlUpdateKey);
        } elseif ($agencyType == '2') {
            $sqlUpdateKey2 = "UPDATE `tbl_updatekeynew` SET `distributorVisitList` = distributorVisitList + 1 WHERE `id` = 1";
            $queryUpdateKey2 = mysqli_query($con, $sqlUpdateKey2);
        }

        $response['status'] = $SuccessStatusCode;
        $response['message'] = $SuccessStatusMsg;
        $response['visitId'] = $visitId;
        http_response_code(200);
    } else {
        die(mysqli_error($con));
        http_response_code(503);
    }
} else {
    $response['status'] = $FailStatusCode;
    $response['message'] = $FailStatusMsg;
}
echo json_encode($response);
