<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../db_config/config1.php';
include_once 'functions/inserLocation.php';

$response = [];
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Data saved successfully!";
$AlreadyStatusCode = 201;
$AlreadyStatusMsg = "Data already registered!";
$FailStatusCode = 202;
$FailStatusMsg = "Unable to register!";

try {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data["empId"]) || empty($data["empId"])) {
        throw new Exception("empId is missing");
    }

    $un = $data['eid'];
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];

    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    $con->set_charset("utf8mb4");

    $farmerId = htmlspecialchars(strip_tags($data["farmerId"] ?? ''));
    $revisitPurpose = htmlspecialchars(strip_tags($data["revisitPurpose"] ?? ''));
    $rDate = htmlspecialchars(strip_tags($data["rDate"] ?? ''));
    $rPhoto = htmlspecialchars(strip_tags($data["rPhoto_key"] ?? ''));
    $empId = htmlspecialchars(strip_tags($data["empId"]));
    $latlong = htmlspecialchars(strip_tags($data["latlong"] ?? ''));
    $action = htmlspecialchars(strip_tags($data["action"] ?? ''));
    $revisit_purpose_id = htmlspecialchars(strip_tags($data["revisit_purpose_id"] ?? ''));
    $actualDateArray = explode(" ", $rDate);
    $actualDate = $actualDateArray[0] ?? '';
    $actualTime = $actualDateArray[1] ?? '';
    $battery = htmlspecialchars(strip_tags($data["battery"] ?? 0));
    $deviceToken = htmlspecialchars(strip_tags($data["deviceToken"] ?? ''));
    $finding = htmlspecialchars(strip_tags($data["finding"] ?? ''));
    $suggestion_to_farmer = htmlspecialchars(strip_tags($data["suggestion_to_farmer"] ?? ''));
    $suggestion_from_farmer = htmlspecialchars(strip_tags($data["suggestion_from_farmer"] ?? ''));

    if ($action === "add") {
        $sqlCheck = "SELECT * FROM tbl_revisit WHERE `farmerId` = '$farmerId' AND `revisit_datetime` = '$rDate' AND `empId` = '$empId'";
        $resultCheck = mysqli_query($con, $sqlCheck);
        if (mysqli_num_rows($resultCheck) === 0) {
            $sql = "INSERT INTO `tbl_revisit` (
                        `farmerId`, `revisitPurpose`, `revisit_datetime`, 
                        `photo`, `empId`, `lat_long`, `revisit_purpose_id`, `finding`, `suggestion_to_farmer`, `suggestion_from_farmer`
                    ) VALUES (
                        '$farmerId', '$revisitPurpose', '$rDate', 
                        '$rPhoto', '$empId', '$latlong', '$revisit_purpose_id', '$finding', '$suggestion_to_farmer', '$suggestion_from_farmer'
                    )";
            mysqli_query($con, $sql);
            $rvId = mysqli_insert_id($con);

            // update keys
            mysqli_query($con, "UPDATE `tbl_updatekeynew` SET `revisit`= `revisit` + 1 WHERE `id`=1");
            mysqli_query($con, "UPDATE `tbl_activity_count_current_year` SET `revisit` = `revisit` + 1 WHERE `empId` = $empId AND `activityDate` = '$actualDate'");

            $rDate1 = date('Y-m-d', strtotime($rDate));
           
            mysqli_query($con, "INSERT INTO `tbl_beat_planning` (`customerType`, `farmerActivityType`, `clientId`, `newRegistration`, `date`, `activity_time`, `empId`, `latlong`, `performedStatus`) VALUES ('1','6','$farmerId','','{$rDate1}','{$actualTime}','$empId','$latlong','1')");

            $activityLatLongArr = explode("#", $latlong);
            $lat = $activityLatLongArr[0] ?? '';
            $long = $activityLatLongArr[1] ?? '';
            insertLocationData($con, $lat, $long, $actualTime, $battery, $empId, $un, $rDate1, $deviceToken, $rvId, '12');

            $response = ['status' => $SuccessStatusCode, 'message' => $SuccessStatusMsg, 'rvId' => $rvId];
        } else {
            $response = ['status' => $AlreadyStatusCode, 'message' => $AlreadyStatusMsg];
        }

    } elseif ($action === "fetch") {
        $rvId = htmlspecialchars(strip_tags($data["rvId"] ?? ''));
        $data2 = [];
        $sql11 = "SELECT *, t1.empId as emp_id FROM `tbl_revisit` t1 
                  LEFT JOIN `tbl_farmer` t2 ON t2.`farmerId` = t1.`farmerId`
                  LEFT JOIN `tbl_category` t3 ON t3.`category_id` = t2.`farmerRegion`
                  LEFT JOIN `tbl_employee` t4 ON t4.`id` = t1.`empId`";
        $query11 = mysqli_query($con, $sql11);
        while ($row = mysqli_fetch_assoc($query11)) {
            $data2[] = [
                "revisitId" => $row["rid"],
                "farmerId" => $row["farmerId"],
                "farmerName" => $row["farmerName"],
                "farmerMobile" => $row["farmerMobile"],
                "farmerCity" => $row["category_name"],
                "farmerLandAcerage" => $row["farmerLandAcerage"],
                "revisitPurpose" => $row["revisitPurpose"],
                "revisit_datetime" => $row["revisit_datetime"],
                "empId" => $row["emp_id"]
            ];
        }
        $response = ['status' => $SuccessStatusCode, 'message' => $SuccessStatusMsg, 'detail' => $data2];

    } elseif ($action === "update") {
        $rvId = htmlspecialchars(strip_tags($data["rvId"] ?? ''));
        $sql = "UPDATE `tbl_revisit` SET 
                    `farmerId` = '$farmerId',
                    `revisitPurpose` = '$revisitPurpose',
                    `revisit_purpose_id` = '$revisit_purpose_id',
                    `finding` = '$finding',
                    `suggestion_to_farmer` = '$suggestion_to_farmer',
                    `suggestion_from_farmer` = '$suggestion_from_farmer'
                WHERE `rid` = '$rvId'";
        $query = mysqli_query($con, $sql);
        if ($query) {
            $response = ['status' => $SuccessStatusCode, 'message' => "Success", 'rvId' => $rvId];
        } else {
            throw new Exception("Failed to update revisit record");
        }

    } else {
        throw new Exception("Invalid action");
    }

} catch (Exception $e) {
    $response = [
        'status' => 500,
        'message' => "Server Error: " . $e->getMessage()
    ];
}

echo json_encode($response);
exit;
?>
