<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
include_once '../db_config/config1.php';
include_once 'functions/getIds.php'; 
$SuccessStatusCode = 200;
$SuccessStatusMsg = "Successful !";
$noDataFoundcode = 201;
$noDataFoundMsg = "Requested data not found !";
$FailStatusCode = 202;
$FailStatusMsg = "Something went wrong ! Unable send you list.";
$unauthorisedUserCode = 203;

$updateMsg = "You are not updated ! Sync required";
$updateNotMsg = "You are updated! Sync not required";


$unauthorisedUserMsg = "Unauthorised access terminated !";
$data = json_decode(file_get_contents("php://input"), true);

function getDaystartEmployeeArray($con,$date){ 
    $queryr="SELECT * FROM `tbl_daystart` WHERE date = '$date'";
    $resultr =$con->query($queryr);
    // print_r($resultr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array(
            'empId' => $datar['uid'],
            'startTime' => $datar['stime']
        );
      }
    //   print_r($arr);
    return $arr;
}
function getEmployeeAllActivityCountArray($con,$date){ 
    $queryr="SELECT empId,(ic + sd + sdv + fd + fm + av) AS totalCount,(`order`+`payment`)  as sumCount FROM `tbl_activity_count_current_year` WHERE activityDate = '$date'";
    $resultr =$con->query($queryr);
    $arr = array();
    while ($datar =$resultr->fetch_assoc()){
        $arr[] = array(
            'empId' => $datar['empId'],
            'totalActivityCount' => $datar['totalCount'],
            'orderPaymentSum' => $datar['sumCount']
        );
      }
    //   print_r($arr);
    return $arr;
}

$response = [];
$todoEmpListArray = [];
// 20.7116935,76.9958865
if (!empty($data["region"]) && !empty($data["eid"]) && !empty($data["page"])) {
    $un = $data['eid'];
    $region = $data['region'];
    $empId = $data['empId'];
    $date = date('Y-m-d');
    //$date = '2024-03-14';
    $un1 = explode("-", $un);
    $un2 = $base_dbname . $un1[0];
    $con = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $un2);
    
    $empids = getEmployeeId($con,$region);
    $dayStartArray = getDaystartEmployeeArray($con,$date);
    $employeeActivityCount = getEmployeeAllActivityCountArray($con,$date);
    // $fromDate = date('Y-m-01');
    // $toDate = date('Y-m-d');
    
    $itemsPerPage = 1000; // Adjust the number of items per page
    $currentPage = isset($data['page']) ? $data['page'] : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;
    
    
    $sql = "SELECT DISTINCT t1.*, 
            (SELECT category_name FROM tbl_category WHERE category_id = t1.region) as region_name 
        FROM 
            `tbl_employee` t1 
        WHERE 
            t1.deleteFlag = 0 
        AND 
            t1.id IN ($empids) 
        AND 
            t1.id != $empId
        ";
    
    $search = isset($data['search']) ? $data['search'] : '';
    
    //  search filter
    if(isset($data['search'])){
        $sql .= " AND ( t1.emp_name LIKE '%$search%' 
                      OR t1.emp_mobile LIKE '%$search%'
                      OR t1.emp_mobile LIKE '%$search%'
                  )";
    }
    
    $sql .= "  ORDER BY t1.emp_name  ASC LIMIT $itemsPerPage OFFSET $offset";
    // echo $sql;
    $query11 = mysqli_query($con, $sql);
    $rowCount11 = mysqli_num_rows($query11);
    
    if ($query11) {
        if ($rowCount11 > 0) { 
            while ($row = mysqli_fetch_array($query11)) {
                if($row['id']){
                    $key = '';
                    $key = array_search($row['id'], array_column($dayStartArray, 'empId'));
                    if ($key === FALSE) {
                        $daystartFlag = 0; //not yet day start
                        $daystartTime = '';
                    } else {
                        $daystartFlag = 1; // day start;
                        $daystartTime = $dayStartArray[$key]['startTime']; // day start time;
                    }
                    $key1 = '';
                    $key1 = array_search($row['id'], array_column($employeeActivityCount, 'empId'));
                    if ($key1 === FALSE) {
                        $totalActivityCount = 0; //not yet day start
                        $orderPaymentSum = 0;
                    } else {
                        $totalActivityCount = $employeeActivityCount[$key1]['totalActivityCount']; // total Activity Count;
                        $orderPaymentSum = $employeeActivityCount[$key1]['orderPaymentSum']; // sum of order+payment;
                    }
                }
                
                array_push(
                    $todoEmpListArray,
                    [
                        "id" => $row['eid'],
                        "empId" => $row['id'],
                        "emp_name" => $row['emp_name'],
                        "emp_mobile" => $row['emp_mobile'],
                        "region" => $row['region_name'],
                        "dayStartFlag" => $daystartFlag,
                        "daystartTime" => $daystartTime,
                        "totalActivityCount" => $totalActivityCount,
                        "orderPaymentSum" => $orderPaymentSum
                    ]
                );
            }
            $response['todoEmpList'] = $todoEmpListArray;
            $response['Count'] = $rowCount11;
            $response['error'] = false;
            $response['status'] = $SuccessStatusCode;
            $response['message'] = $SuccessStatusMsg;
        } else {
            $response['error'] = true;
            $response['status'] = $noDataFoundcode;
            $response['message'] = $noDataFoundMsg;
        }
        
        
    } else {
        $response['error'] = true;
        $response['status'] = $FailStatusCode;
        $response['message'] = $FailStatusMsg;
    }
} else {
    $response['error'] = true;
    $response['statu'] = 301;
    $response['message'] = "Field missing";
}

echo json_encode($response);
