<?php
error_reporting(E_ALL); // Change to E_ALL during testing
include_once '../db_config/config1.php'; // Adjust path as needed
require_once '../db_config/configmulti.php';

function calculateAttendanceFlag($stime, $etime, $shift) {
    $stime_ts = $stime ? strtotime($stime) : null;
    $etime_ts = $etime ? strtotime($etime) : null;

    $late_start_ts  = isset($shift['late_mark_start']) ? strtotime($shift['late_mark_start']) : 0;
    $late_end_ts    = isset($shift['late_mark_end'])   ? strtotime($shift['late_mark_end']) : 0;
    $half_day_ts    = isset($shift['half_day_time'])   ? strtotime($shift['half_day_time']) : 0;
    $early_start_ts = isset($shift['early_mark_start'])? strtotime($shift['early_mark_start']) : 0;
    $early_end_ts   = isset($shift['early_mark_end'])  ? strtotime($shift['early_mark_end']) : 0;
    $shift_end      = isset($shift['login_end'])       ? strtotime($shift['login_end']) : 0;
    $work_hour      = isset($shift['work_hour'])       ? strtotime($shift['work_hour']) - strtotime("00:00:00") : 8 * 3600;

    if ($stime_ts && !$etime_ts) {
        if ($stime_ts >= $late_start_ts && $stime_ts <= $late_end_ts) return 1;
        if ($stime_ts >= $late_end_ts && $stime_ts <= $half_day_ts) return 3;
        if ($stime_ts > $half_day_ts) return 9;
        return 0;
    }

    if ($stime_ts && $etime_ts) {
        $actual_worked = $etime_ts - $stime_ts;

        if ($etime_ts < $half_day_ts) return 9;

        $isVeryLate  = ($stime_ts > $half_day_ts);
        $isLateLogin = ($stime_ts >= $late_start_ts && $stime_ts <= $late_end_ts);
        $isTooShort  = ($actual_worked < $work_hour);
        $isEarlyOut  = ($etime_ts > $half_day_ts && $etime_ts < $early_end_ts);

        if ($isEarlyOut && $isTooShort) return 6;
        if ($isEarlyOut) return 4;
        if ($isTooShort) return 2;
    }

    return 9;
}

$db_prefix = 'frts';
$clientDbName = $base_dbname . $db_prefix;
$mysql = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, $clientDbName);
if ($mysql->connect_error) {
    $response["error"] = true;
    $response["MESSAGE"] = "Database connection failed: " . $mysql->connect_error;
    echo json_encode($response);
    exit;
}
    
// Step 1: Get all active employees with shift assigned
$empQuery = "SELECT id, shift FROM tbl_employee WHERE shift > 0";
$empResult = $mysql->query($empQuery);

if ($empResult && $empResult->num_rows > 0) {
    while ($emp = $empResult->fetch_assoc()) {
        $empId = $emp['id'];
        $shiftId = $emp['shift'];

        // Step 2: Get shift details once
        $shiftQuery = "SELECT late_mark_start, late_mark_end, half_day_time, early_mark_end, work_hour 
                       FROM tbl_emp_shift WHERE id = '$shiftId' AND is_active = 1 AND deleteFlag = 0 LIMIT 1";
        $shiftResult = $mysql->query($shiftQuery);
        if (!$shiftResult || $shiftResult->num_rows == 0) continue;

        $shift = $shiftResult->fetch_assoc();

        // Step 3: Get all daystart records for employee
        $dayQuery = "SELECT id, date, stime, etime FROM tbl_daystart 
                     WHERE uid = '$empId' AND isDeleted = 0";
        $dayResult = $mysql->query($dayQuery);

        if ($dayResult && $dayResult->num_rows > 0) {
            while ($row = $dayResult->fetch_assoc()) {
                $dayId = $row['id'];
                $date = $row['date'];
                $stime = $row['stime'];
                $etime = $row['etime'];

                $delayFlag = calculateAttendanceFlag($stime, null, $shift);
               
                
                $stime_ts = strtotime('1970-01-01 ' . $stime);
                $etime_ts = strtotime('1970-01-01 ' . $etime);
                
                $total_seconds = ($etime_ts && $stime_ts) ? $etime_ts - $stime_ts : 0;
                $total_hours_decimal = round($total_seconds / 3600, 2); // e.g. 7.75
                
                $hours   = floor($total_seconds / 3600);
                $minutes = floor(($total_seconds % 3600) / 60);
                $seconds = $total_seconds % 60;
                
                $hours = isset($hours) ? (int)$hours : 0;
                $minutes = isset($minutes) ? (int)$minutes : 0;
                $seconds = isset($seconds) ? (int)$seconds : 0;
            
                $total_hours = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds); // e.g. 07:45:30

                //Update delay flag
                $update = "UPDATE tbl_daystart 
                        SET 
                            delayFlag = '$delayFlag', 
                            total_hours = '$total_hours' 
                        WHERE 
                            id = '$dayId'
                        AND
                            status = 1";
                $mysql->query($update);

                // Log late login if necessary
                if (in_array($delayFlag, [1, 3, 5, 9])) {
                    $checkLate = $mysql->query("SELECT id FROM tbl_late_login WHERE empId = '$empId' AND date = '$date' LIMIT 1");
                    if ($checkLate->num_rows == 0) {
                        $mysql->query("INSERT INTO tbl_late_login (empId, date, time) VALUES ('$empId', '$date', '$stime')");
                    }
                }
            }
        }
    }
    echo "Delay flags updated by employee-wise iteration.";
}else{
echo 'Skiped If Loop';    
}

